/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.selenium;

import com.google.common.net.InetAddresses;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.selenium.SeleniumProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.BrowserWebDriverContainer;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.DefaultRecordingFileFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.RecordingFileFactory;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@AutoConfiguration(after={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(name={"embedded.selenium.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SeleniumProperties.class})
public class EmbeddedSeleniumBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedSeleniumBootstrapConfiguration.class);
    private static final String TC_TEMP_DIR_PREFIX = "tc";
    public static final String DEFINED_VNC_USERNAME = "vnc";
    public static final String DEFINED_VNC_PASSWORD = "secret";
    public static final String DOCKER_FOR_LINUX_STATIC_IP = "172.17.0.1";

    @Bean
    @ConditionalOnMissingBean(value={MutableCapabilities.class})
    @ConditionalOnProperty(value={"embedded.selenium.browser"}, havingValue="CHROMIUM", matchIfMissing=true)
    public ChromeOptions chromeOptions(SeleniumProperties properties) {
        ChromeOptions options = new ChromeOptions();
        properties.apply(options);
        return options;
    }

    @Bean
    @ConditionalOnMissingBean(value={MutableCapabilities.class})
    @ConditionalOnProperty(value={"embedded.selenium.browser"}, havingValue="FIREFOX")
    public FirefoxOptions firefoxOptions(SeleniumProperties properties) {
        FirefoxOptions options = new FirefoxOptions();
        properties.apply(options);
        return options;
    }

    @Bean(name={"embeddedSelenium"}, destroyMethod="stop")
    @ConditionalOnMissingBean
    public BrowserWebDriverContainer selenium(ConfigurableEnvironment environment, SeleniumProperties properties, MutableCapabilities capabilities, @Deprecated @Value(value="${embedded.selenium.imageName:#{null}}") String deprImageName) {
        if (deprImageName != null) {
            throw new IllegalArgumentException("`embedded.selenium.imageName` property is deprecated. Please replace `embedded.selenium.imageName` property with `embedded.selenium.dockerImage` property.");
        }
        BrowserWebDriverContainer container = this.isNotBlank(properties.getDockerImage()) ? new BrowserWebDriverContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)) : new BrowserWebDriverContainer();
        container.setWaitStrategy(this.getWaitStrategy());
        container.withCapabilities((Capabilities)capabilities);
        container.withRecordingFileFactory(this.getRecordingFileFactory());
        File recordingDirOrNull = null;
        if (properties.getVnc().getMode().convert() != BrowserWebDriverContainer.VncRecordingMode.SKIP) {
            recordingDirOrNull = this.getOrCreateTempDir(properties.getVnc().getRecordingDir());
        }
        container.withRecordingMode(properties.getVnc().getMode().convert(), recordingDirOrNull);
        ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        Map<String, Object> seleniumEnv = this.registerSeleniumEnvironment(environment, container, properties.getVnc().getMode().convert(), recordingDirOrNull);
        log.info("Started Selenium server. Connection details: {}", seleniumEnv);
        return container;
    }

    @Deprecated
    private WaitStrategy getWaitStrategy() {
        WaitStrategy logWaitStrategy = new LogMessageWaitStrategy().withRegEx(".*(RemoteWebDriver instances should connect to|Selenium Server is up and running).*\n").withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
        return new WaitAllStrategy().withStrategy(logWaitStrategy).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
    }

    private File getOrCreateTempDir(File vncRecordingDirProperty) {
        if (vncRecordingDirProperty != null) {
            return vncRecordingDirProperty;
        }
        try {
            return Files.createTempDirectory(TC_TEMP_DIR_PREFIX, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            log.error("Exception while trying to create temp directory ", (Throwable)e);
            throw new ContainerLaunchException("Exception while trying to create temp directory", (Throwable)e);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public RecordingFileFactory getRecordingFileFactory() {
        return new DefaultRecordingFileFactory();
    }

    private Map<String, Object> registerSeleniumEnvironment(ConfigurableEnvironment environment, BrowserWebDriverContainer container, BrowserWebDriverContainer.VncRecordingMode vncMode, File recordingDirOrNull) {
        URL seleniumAddress = container.getSeleniumAddress();
        String vncAddress = container.getVncAddress();
        URI vncURI = URI.create(vncAddress);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.selenium.port", seleniumAddress.getPort());
        map.put("embedded.selenium.host", seleniumAddress.getHost());
        map.put("embedded.selenium.vnc.port", vncURI.getPort());
        map.put("embedded.selenium.vnc.host", vncURI.getHost());
        map.put("embedded.selenium.vnc.username", DEFINED_VNC_USERNAME);
        map.put("embedded.selenium.vnc.password", DEFINED_VNC_PASSWORD);
        map.put("embedded.selenium.vnc.recording-dir", recordingDirOrNull);
        map.put("embedded.selenium.vnc.mode", vncMode);
        map.put("embedded.selenium.dockerhost", this.getHostName((GenericContainer<?>)container));
        MapPropertySource propertySource = new MapPropertySource("embeddedSeleniumInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        return map;
    }

    public String getHostName(GenericContainer<?> container) {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0) {
            return "host.docker.internal";
        }
        if (OS.indexOf("win") >= 0) {
            return "host.docker.internal";
        }
        if (OS.indexOf("nux") >= 0) {
            Container.ExecResult execResult;
            try {
                execResult = container.execInContainer(new String[]{"/sbin/ip route|awk '/default/ { print $3 }'"});
            }
            catch (IOException e) {
                log.warn("Cannot find host ip", (Throwable)e);
                return DOCKER_FOR_LINUX_STATIC_IP;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return DOCKER_FOR_LINUX_STATIC_IP;
            }
            String hostIpAddress = execResult.getStdout();
            if (this.isValidIpAddress(hostIpAddress)) {
                return hostIpAddress;
            }
            return DOCKER_FOR_LINUX_STATIC_IP;
        }
        return container.getTestHostIpAddress();
    }

    private boolean isValidIpAddress(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        return InetAddresses.isInetAddress((String)ipAddress);
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }
}

