/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.selenium;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.selenium.BrowserType;
import com.playtika.testcontainer.selenium.VncRecordingMode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.selenium")
public class SeleniumProperties
extends CommonContainerProperties {
    public static final String BEAN_NAME_EMBEDDED_SELENIUM = "embeddedSelenium";
    public static final String BEAN_NAME_EMBEDDED_SELENIUM_DRIVER = "embeddedSeleniumDriver";
    private BrowserType browser = BrowserType.CHROMIUM;
    private List<String> arguments = new ArrayList<String>();
    private Vnc vnc = new Vnc();

    public String getDefaultDockerImage() {
        return null;
    }

    public FirefoxOptions apply(FirefoxOptions options) {
        options.addArguments(this.arguments);
        return options;
    }

    public ChromeOptions apply(ChromeOptions options) {
        options.addArguments(this.arguments);
        return options;
    }

    public BrowserType getBrowser() {
        return this.browser;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public Vnc getVnc() {
        return this.vnc;
    }

    public void setBrowser(BrowserType browser) {
        this.browser = browser;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public void setVnc(Vnc vnc) {
        this.vnc = vnc;
    }

    public String toString() {
        return "SeleniumProperties(browser=" + (Object)((Object)this.getBrowser()) + ", arguments=" + this.getArguments() + ", vnc=" + this.getVnc() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeleniumProperties)) {
            return false;
        }
        SeleniumProperties other = (SeleniumProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BrowserType this$browser = this.getBrowser();
        BrowserType other$browser = other.getBrowser();
        if (this$browser == null ? other$browser != null : !((Object)((Object)this$browser)).equals((Object)other$browser)) {
            return false;
        }
        List<String> this$arguments = this.getArguments();
        List<String> other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        Vnc this$vnc = this.getVnc();
        Vnc other$vnc = other.getVnc();
        return !(this$vnc == null ? other$vnc != null : !((Object)this$vnc).equals(other$vnc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeleniumProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BrowserType $browser = this.getBrowser();
        result = result * 59 + ($browser == null ? 43 : ((Object)((Object)$browser)).hashCode());
        List<String> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        Vnc $vnc = this.getVnc();
        result = result * 59 + ($vnc == null ? 43 : ((Object)$vnc).hashCode());
        return result;
    }

    public static class Vnc {
        private File recordingDir = null;
        private VncRecordingMode mode = VncRecordingMode.SKIP;

        public File getRecordingDir() {
            return this.recordingDir;
        }

        public VncRecordingMode getMode() {
            return this.mode;
        }

        public void setRecordingDir(File recordingDir) {
            this.recordingDir = recordingDir;
        }

        public void setMode(VncRecordingMode mode) {
            this.mode = mode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vnc)) {
                return false;
            }
            Vnc other = (Vnc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$recordingDir = this.getRecordingDir();
            File other$recordingDir = other.getRecordingDir();
            if (this$recordingDir == null ? other$recordingDir != null : !((Object)this$recordingDir).equals(other$recordingDir)) {
                return false;
            }
            VncRecordingMode this$mode = this.getMode();
            VncRecordingMode other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Vnc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $recordingDir = this.getRecordingDir();
            result = result * 59 + ($recordingDir == null ? 43 : ((Object)$recordingDir).hashCode());
            VncRecordingMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
            return result;
        }

        public String toString() {
            return "SeleniumProperties.Vnc(recordingDir=" + this.getRecordingDir() + ", mode=" + (Object)((Object)this.getMode()) + ")";
        }
    }
}

