/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.spicedb;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.spicedb.SpiceDBProperties;
import com.playtika.testcontainer.toxiproxy.EmbeddedToxiProxyBootstrapConfiguration;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class, EmbeddedToxiProxyBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.spicedb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SpiceDBProperties.class})
public class EmbeddedSpiceDBBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedSpiceDBBootstrapConfiguration.class);
    private static final String NATS_NETWORK_ALIAS = "spicedb.testcontainer.docker";

    @Bean(name={"embeddedSpiceDbToxiProxy"})
    @ConditionalOnToxiProxyEnabled(module="spicedb")
    ToxiproxyContainer.ContainerProxy spicedbContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedSpiceDB") GenericContainer<?> spicedbContainer, SpiceDBProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(spicedbContainer, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.spicedb.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.spicedb.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.spicedb.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedSpicedbToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Spicedb ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedSpiceDB"}, destroyMethod="stop")
    public GenericContainer<?> spicedbContainer(ConfigurableEnvironment environment, SpiceDBProperties properties, Optional<Network> network) {
        WaitAllStrategy waitStrategy = new WaitAllStrategy().withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStartupTimeout(properties.getTimeoutDuration());
        GenericContainer spicedbContainer = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()}).withCommand(new String[]{"serve", "--grpc-preshared-key", properties.getPresharedKey(), "--skip-release-check"}).waitingFor((WaitStrategy)waitStrategy).withNetworkAliases(new String[]{NATS_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)spicedbContainer).withNetwork(arg_0));
        spicedbContainer = ContainerUtils.configureCommonsAndStart((GenericContainer)spicedbContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerNatsEnvironment(spicedbContainer, environment, properties);
        return spicedbContainer;
    }

    private void registerNatsEnvironment(GenericContainer<?> natsContainer, ConfigurableEnvironment environment, SpiceDBProperties properties) {
        Integer clientMappedPort = natsContainer.getMappedPort(properties.getPort());
        String host = natsContainer.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.spicedb.host", host);
        map.put("embedded.spicedb.port", clientMappedPort);
        map.put("embedded.spicedb.token", properties.getPresharedKey());
        map.put("embedded.spicedb.networkAlias", NATS_NETWORK_ALIAS);
        log.info("Started SpiceDb server. Connection details {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedSpicedbInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

