/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.temporal;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.temporal.TemporalProperties;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.temporal.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={TemporalProperties.class})
public class EmbeddedTemporalBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedTemporalBootstrapConfiguration.class);
    private static final String TEMPORAL_NETWORK_ALIAS = "temporal.testcontainer.docker";

    @Bean(value={"embeddedTemporal"}, destroyMethod="stop")
    public GenericContainer<?> temporal(ConfigurableEnvironment environment, TemporalProperties properties, Optional<Network> network) {
        GenericContainer container = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withCreateContainerCmdModifier(cmd -> cmd.withEntrypoint(new String[]{"temporal", "server", "start-dev"})).withCommand(new String[]{"--ip", "0.0.0.0", "--headless"}).withExposedPorts(new Integer[]{7233}).withNetworkAliases(new String[]{TEMPORAL_NETWORK_ALIAS}).waitingFor((WaitStrategy)new HostPortWaitStrategy());
        if (properties.isUiEnabled()) {
            container.withCommand(new String[]{"--ip", "0.0.0.0"}).addExposedPort(Integer.valueOf(8233));
        }
        network.ifPresent(arg_0 -> ((GenericContainer)container).withNetwork(arg_0));
        ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerTemporalEnvironment(container, environment, properties);
        return container;
    }

    private void registerTemporalEnvironment(GenericContainer<?> container, ConfigurableEnvironment environment, TemporalProperties properties) {
        String host = container.getHost();
        Integer port = container.getMappedPort(7233);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.temporal.host", host);
        map.put("embedded.temporal.port", port);
        map.put("embedded.temporal.networkAlias", TEMPORAL_NETWORK_ALIAS);
        map.put("embedded.temporal.internalPort", 7233);
        log.info("Temporal Server started. Available on: http://{}:{}", (Object)host, (Object)port);
        if (properties.isUiEnabled()) {
            Integer uiPort = container.getMappedPort(8233);
            map.put("embedded.temporal.uiPort", uiPort);
            log.info("Temporal UI started. Available on: http://{}:{}", (Object)host, (Object)uiPort);
        }
        MapPropertySource propertySource = new MapPropertySource("embeddedTemporalInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

