/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.toxiproxy;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.toxiproxy.ToxiProxyProperties;
import com.playtika.test.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnToxiProxyEnabled
@EnableConfigurationProperties(value={ToxiProxyProperties.class})
public class EmbeddedToxiProxyBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedToxiProxyBootstrapConfiguration.class);
    private static final String TOXIPROXY_NETWORK_ALIAS = "toxiproxy";

    @Bean
    @ConditionalOnMissingBean(value={Network.class})
    Network toxiproxyNetwork() {
        return Network.newNetwork();
    }

    @Bean(name={"toxiproxy"}, destroyMethod="stop")
    ToxiproxyContainer toxiproxy(ToxiProxyProperties toxiProxyProperties, Network network, ConfigurableEnvironment environment) {
        ToxiproxyContainer toxiproxyContainer = (ToxiproxyContainer)((ToxiproxyContainer)new ToxiproxyContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)toxiProxyProperties)).withNetwork(network)).withNetworkAliases(new String[]{TOXIPROXY_NETWORK_ALIAS});
        toxiproxyContainer = (ToxiproxyContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)toxiproxyContainer, (CommonContainerProperties)toxiProxyProperties, (Logger)log);
        this.registerEnvironment(toxiproxyContainer, environment);
        return toxiproxyContainer;
    }

    private void registerEnvironment(ToxiproxyContainer container, ConfigurableEnvironment environment) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.toxiproxy.host", container.getContainerIpAddress());
        map.put("embedded.toxiproxy.controlPort", container.getControlPort());
        log.info("Started ToxiProxy server. Connection details {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedToxiProxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

