/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.toxiproxy.condition;

import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ToxiProxyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnToxiProxyEnabled.class.getName());
        String module = (String)attributes.get("module");
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Toxi Proxy Proxies Configured Condition", (Object[])new Object[0]);
        ToxiProxyProxiesProperties properties = this.getProperties(context);
        if (properties == null) {
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("toxi proxy properties"));
        }
        if (properties.getEnabled() != null && !properties.getEnabled().booleanValue()) {
            return ConditionOutcome.noMatch((ConditionMessage)message.because("toxi proxy is disabled"));
        }
        if (properties.getEnabled() != null && properties.getEnabled().booleanValue()) {
            return ConditionOutcome.match((ConditionMessage)message.because("toxi proxy is enabled"));
        }
        if (properties.getProxies().isEmpty()) {
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("proxies").atAll());
        }
        Set enabledProxies = properties.getProxies().entrySet().stream().filter(e -> ((ToxiProxyProxiesProperties.ModuleProxyProperties)e.getValue()).isEnabled()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (module.isEmpty()) {
            if (!enabledProxies.isEmpty()) {
                return ConditionOutcome.match((ConditionMessage)message.found("enabled").items(enabledProxies));
            }
        } else if (enabledProxies.contains(module)) {
            return ConditionOutcome.match((ConditionMessage)message.found("enabled").items(new Object[]{module}));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("enabled").items(new Object[]{"proxy"}));
    }

    private ToxiProxyProxiesProperties getProperties(ConditionContext context) {
        return (ToxiProxyProxiesProperties)Binder.get((Environment)context.getEnvironment()).bind("embedded.toxiproxy", ToxiProxyProxiesProperties.class).orElse(null);
    }

    @ConfigurationProperties(value="embedded.toxiproxy")
    public static class ToxiProxyProxiesProperties {
        Boolean enabled;
        Map<String, ModuleProxyProperties> proxies = new HashMap<String, ModuleProxyProperties>();

        @Generated
        public ToxiProxyProxiesProperties() {
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<String, ModuleProxyProperties> getProxies() {
            return this.proxies;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setProxies(Map<String, ModuleProxyProperties> proxies) {
            this.proxies = proxies;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ToxiProxyProxiesProperties)) {
                return false;
            }
            ToxiProxyProxiesProperties other = (ToxiProxyProxiesProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Map<String, ModuleProxyProperties> this$proxies = this.getProxies();
            Map<String, ModuleProxyProperties> other$proxies = other.getProxies();
            return !(this$proxies == null ? other$proxies != null : !((Object)this$proxies).equals(other$proxies));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ToxiProxyProxiesProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Map<String, ModuleProxyProperties> $proxies = this.getProxies();
            result = result * 59 + ($proxies == null ? 43 : ((Object)$proxies).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ToxiProxyCondition.ToxiProxyProxiesProperties(enabled=" + this.getEnabled() + ", proxies=" + String.valueOf(this.getProxies()) + ")";
        }

        public static class ModuleProxyProperties {
            boolean enabled;

            @Generated
            public ModuleProxyProperties() {
            }

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ModuleProxyProperties)) {
                    return false;
                }
                ModuleProxyProperties other = (ModuleProxyProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.isEnabled() == other.isEnabled();
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ModuleProxyProperties;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isEnabled() ? 79 : 97);
                return result;
            }

            @Generated
            public String toString() {
                return "ToxiProxyCondition.ToxiProxyProxiesProperties.ModuleProxyProperties(enabled=" + this.isEnabled() + ")";
            }
        }
    }
}

