/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.vault;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.vault.VaultProperties;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.vault.VaultContainer;

@Order(value=-2147483648)
@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.vault.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={VaultProperties.class})
public class EmbeddedVaultBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVaultBootstrapConfiguration.class);

    @Bean(name={"embeddedVault"}, destroyMethod="stop")
    public VaultContainer vault(ConfigurableEnvironment environment, VaultProperties properties) {
        VaultContainer vault = (VaultContainer)new VaultContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withVaultToken(properties.getToken()).withExposedPorts(new Integer[]{properties.getPort()});
        String[] secrets = (String[])properties.getSecrets().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).toArray(String[]::new);
        if (secrets.length > 0) {
            vault.withSecretInVault(properties.getPath(), secrets[0], Arrays.copyOfRange(secrets, 1, secrets.length));
        }
        if (properties.isCasEnabled()) {
            log.info("Enabling cas for mount secret");
            vault.withInitCommand(new String[]{"write secret/config cas_required=true"});
        }
        if (!properties.getCasEnabledForSubPaths().isEmpty()) {
            this.enableCasForSubPaths(properties.getCasEnabledForSubPaths(), vault);
        }
        vault = (VaultContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)vault, (CommonContainerProperties)properties, (Logger)log);
        this.registerVaultEnvironment(vault, environment, properties);
        return vault;
    }

    private void registerVaultEnvironment(VaultContainer vault, ConfigurableEnvironment environment, VaultProperties properties) {
        Integer mappedPort = vault.getMappedPort(properties.getPort());
        String host = vault.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.vault.host", host);
        map.put("embedded.vault.port", mappedPort);
        map.put("embedded.vault.token", properties.getToken());
        log.info("Started vault. Connection Details: {}, Connection URI: http://{}:{}", new Object[]{map, host, mappedPort});
        MapPropertySource propertySource = new MapPropertySource("embeddedVaultInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private void enableCasForSubPaths(List<String> subPaths, VaultContainer vault) {
        for (String subPath : subPaths) {
            if (subPath.isEmpty()) continue;
            log.info("Vault: Enabling cas for sub path {}", (Object)subPath);
            vault.withInitCommand(new String[]{"kv metadata put -cas-required=true secret/" + subPath});
        }
    }
}

