/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.vault;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import com.playtika.testcontainer.vault.VaultProperties;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.vault.VaultContainer;

@Order(value=-2147483648)
@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.vault.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={VaultProperties.class})
public class EmbeddedVaultBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVaultBootstrapConfiguration.class);
    private static final String VAULT_NETWORK_ALIAS = "vault.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="vault")
    ToxiproxyContainer.ContainerProxy vaultContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedVault") VaultContainer vault, ConfigurableEnvironment environment, VaultProperties properties) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)vault, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.vault.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.vault.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.vault.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedVaultToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Vault ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedVault"}, destroyMethod="stop")
    public VaultContainer vault(ConfigurableEnvironment environment, VaultProperties properties, Optional<Network> network) {
        VaultContainer vault = (VaultContainer)((VaultContainer)new VaultContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withVaultToken(properties.getToken()).withExposedPorts(new Integer[]{properties.getPort()})).withNetworkAliases(new String[]{VAULT_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((VaultContainer)vault).withNetwork(arg_0));
        String[] secrets = (String[])properties.getSecrets().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).toArray(String[]::new);
        if (secrets.length > 0) {
            vault.withSecretInVault(properties.getPath(), secrets[0], Arrays.copyOfRange(secrets, 1, secrets.length));
        }
        if (properties.isCasEnabled()) {
            log.info("Enabling cas for mount secret");
            vault.withInitCommand(new String[]{"write secret/config cas_required=true"});
        }
        if (!properties.getCasEnabledForSubPaths().isEmpty()) {
            this.enableCasForSubPaths(properties.getCasEnabledForSubPaths(), vault);
        }
        vault = (VaultContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)vault, (CommonContainerProperties)properties, (Logger)log);
        this.registerVaultEnvironment(vault, environment, properties);
        return vault;
    }

    private void registerVaultEnvironment(VaultContainer vault, ConfigurableEnvironment environment, VaultProperties properties) {
        Integer mappedPort = vault.getMappedPort(properties.getPort());
        String host = vault.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.vault.host", host);
        map.put("embedded.vault.port", mappedPort);
        map.put("embedded.vault.token", properties.getToken());
        map.put("embedded.vault.networkAlias", VAULT_NETWORK_ALIAS);
        map.put("embedded.vault.internalPort", properties.getPort());
        log.info("Started vault. Connection Details: {}, Connection URI: http://{}:{}", new Object[]{map, host, mappedPort});
        MapPropertySource propertySource = new MapPropertySource("embeddedVaultInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private void enableCasForSubPaths(List<String> subPaths, VaultContainer vault) {
        for (String subPath : subPaths) {
            if (subPath.isEmpty()) continue;
            log.info("Vault: Enabling cas for sub path {}", (Object)subPath);
            vault.withInitCommand(new String[]{"kv metadata put -cas-required=true secret/" + subPath});
        }
    }
}

