/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.vertica;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.vertica.VerticaProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.vertica.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VerticaProperties.class})
public class EmbeddedVerticaBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVerticaBootstrapConfiguration.class);

    @Bean(name={"embeddedVertica"}, destroyMethod="stop")
    public GenericContainer embeddedVertica(ConfigurableEnvironment environment, VerticaProperties properties) {
        log.info("Starting Vertica server. Docker image: {}", (Object)properties.getDockerImage());
        GenericContainer verticaContainer = ContainerUtils.configureCommonsAndStart((GenericContainer)this.createContainer(properties), (CommonContainerProperties)properties, (Logger)log);
        this.registerVerticaEnvironment(verticaContainer, environment, properties);
        return verticaContainer;
    }

    private GenericContainer createContainer(VerticaProperties properties) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("DATABASE_NAME", properties.getDatabase());
        map.put("DATABASE_PASSWORD", properties.getPassword());
        return new GenericContainer(properties.getDockerImage()).withExposedPorts(new Integer[]{properties.getPort()}).withEnv(map).waitingFor((WaitStrategy)new HostPortWaitStrategy());
    }

    private void registerVerticaEnvironment(GenericContainer verticaContainer, ConfigurableEnvironment environment, VerticaProperties properties) {
        Integer mappedPort = verticaContainer.getMappedPort(properties.getPort().intValue());
        String host = verticaContainer.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.vertica.port", mappedPort);
        map.put("embedded.vertica.host", host);
        map.put("embedded.vertica.database", properties.getDatabase());
        map.put("embedded.vertica.user", properties.getUser());
        map.put("embedded.vertica.password", properties.getPassword());
        MapPropertySource propertySource = new MapPropertySource("embeddedVerticaInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Vertica server. Connection details: {}, ", map);
    }
}

