/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.vertica;

import com.playtika.test.common.spring.DependsOnPostProcessor;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder
@ConditionalOnClass(value={DataSource.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.vertica.enabled"}, matchIfMissing=true)
public class EmbeddedVerticaDependenciesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVerticaDependenciesAutoConfiguration.class);

    @Bean
    public static BeanFactoryPostProcessor datasourceVerticaDependencyPostProcessor() {
        return new DependsOnPostProcessor(DataSource.class, new String[]{"embeddedVertica"});
    }
}

