/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.vertica;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import com.playtika.testcontainer.vertica.VerticaProperties;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.vertica.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={VerticaProperties.class})
public class EmbeddedVerticaBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVerticaBootstrapConfiguration.class);
    private static final String VERTICA_NETWORK_ALIAS = "vertica.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="vertica")
    ToxiproxyContainer.ContainerProxy verticaContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedVertica") GenericContainer<?> embeddedVertica, ConfigurableEnvironment environment, VerticaProperties verticaProperties) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(embeddedVertica, verticaProperties.getPort().intValue());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.vertica.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.vertica.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.vertica.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedVerticaToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Vertica ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedVertica"}, destroyMethod="stop")
    public GenericContainer<?> embeddedVertica(ConfigurableEnvironment environment, VerticaProperties properties, Optional<Network> network) {
        GenericContainer verticaContainer = ContainerUtils.configureCommonsAndStart(this.createContainer(properties), (CommonContainerProperties)properties, (Logger)log).withNetworkAliases(new String[]{VERTICA_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)verticaContainer).withNetwork(arg_0));
        this.registerVerticaEnvironment(verticaContainer, environment, properties);
        return verticaContainer;
    }

    private GenericContainer<?> createContainer(VerticaProperties properties) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("DATABASE_NAME", properties.getDatabase());
        map.put("DATABASE_PASSWORD", properties.getPassword());
        return new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()}).withEnv(map).waitingFor((WaitStrategy)new HostPortWaitStrategy());
    }

    private void registerVerticaEnvironment(GenericContainer<?> verticaContainer, ConfigurableEnvironment environment, VerticaProperties properties) {
        Integer mappedPort = verticaContainer.getMappedPort(properties.getPort().intValue());
        String host = verticaContainer.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.vertica.port", mappedPort);
        map.put("embedded.vertica.host", host);
        map.put("embedded.vertica.database", properties.getDatabase());
        map.put("embedded.vertica.user", properties.getUser());
        map.put("embedded.vertica.password", properties.getPassword());
        map.put("embedded.vertica.networkAlias", VERTICA_NETWORK_ALIAS);
        map.put("embedded.vertica.internalPort", properties.getPort());
        MapPropertySource propertySource = new MapPropertySource("embeddedVerticaInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Vertica server. Connection details: {}, ", map);
    }
}

