/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.victoriametrics;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.toxiproxy.EmbeddedToxiProxyBootstrapConfiguration;
import com.playtika.test.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import com.playtika.test.victoriametrics.VictoriaMetricsProperties;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@EnableConfigurationProperties(value={VictoriaMetricsProperties.class})
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class, EmbeddedToxiProxyBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.victoriametrics.enabled"}, matchIfMissing=true)
public class EmbeddedVictoriaMetricsBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedVictoriaMetricsBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"victoriaMetricsWaitStrategy"})
    public WaitStrategy victoriaMetricsWaitStrategy(VictoriaMetricsProperties properties) {
        return new HttpWaitStrategy().forPath("/").forPort(properties.getPort()).forStatusCode(200);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="victoriametrics")
    public ToxiproxyContainer.ContainerProxy victoriaMetricsContainerProxy(ToxiproxyContainer toxiproxy, GenericContainer<?> victoriametrics, VictoriaMetricsProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxy.getProxy(victoriametrics, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.victoriametrics.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.victoriametrics.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.victoriametrics.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedVictoriaMetricsToxiProxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("VictoriaMetrics ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"victoriametrics"}, destroyMethod="stop")
    public GenericContainer<?> victoriaMetrics(ConfigurableEnvironment environment, VictoriaMetricsProperties properties, WaitStrategy victoriaMetricsWaitStrategy, Optional<Network> network) {
        GenericContainer victoriaMetrics = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()}).withNetwork(Network.SHARED).withNetworkAliases(new String[]{properties.getNetworkAlias()}).waitingFor(victoriaMetricsWaitStrategy);
        network.ifPresent(arg_0 -> ((GenericContainer)victoriaMetrics).withNetwork(arg_0));
        ContainerUtils.configureCommonsAndStart((GenericContainer)victoriaMetrics, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(victoriaMetrics, environment, properties);
        return victoriaMetrics;
    }

    private void registerEnvironment(GenericContainer<?> victoriaMetrics, ConfigurableEnvironment environment, VictoriaMetricsProperties properties) {
        Integer mappedPort = victoriaMetrics.getMappedPort(properties.port);
        String host = victoriaMetrics.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.victoriametrics.host", host);
        map.put("embedded.victoriametrics.port", mappedPort);
        log.info("Started VictoriaMetrics server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedVictoriaMetricsInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

