/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainers.wiremock;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainers.wiremock.WiremockProperties;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.wiremock.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={WiremockProperties.class})
public class EmbeddedWiremockBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedWiremockBootstrapConfiguration.class);
    static final String BEAN_NAME_EMBEDDED_WIREMOCK = "embeddedWiremock";
    private static final String WIREMOCK_NETWORK_ALIAS = "wiremock.testcontainer.docker";
    private static final WaitStrategy DEFAULT_WAITER = Wait.forHttp((String)"/__admin/mappings").withMethod("GET").forStatusCode(200);

    @Bean(value={"embeddedWiremock"}, destroyMethod="stop")
    public GenericContainer<?> wiremockContainer(ConfigurableEnvironment environment, WiremockProperties properties, Optional<Network> network) {
        GenericContainer wiremock = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).waitingFor(DEFAULT_WAITER).withCommand("--port " + properties.getPort()).withExposedPorts(new Integer[]{properties.getPort()}).withNetworkAliases(new String[]{WIREMOCK_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)wiremock).withNetwork(arg_0));
        wiremock = ContainerUtils.configureCommonsAndStart((GenericContainer)wiremock, (CommonContainerProperties)properties, (Logger)log);
        this.registerWiremockEnvironment(wiremock, environment, properties);
        return wiremock;
    }

    private void registerWiremockEnvironment(GenericContainer<?> container, ConfigurableEnvironment environment, WiremockProperties properties) {
        Integer mappedPort = container.getMappedPort(properties.getPort());
        String host = container.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.wiremock.port", mappedPort);
        map.put("embedded.wiremock.host", host);
        map.put("embedded.wiremock.networkAlias", WIREMOCK_NETWORK_ALIAS);
        map.put("embedded.wiremock.internalPort", properties.getPort());
        log.info("Started wiremock. Connection Details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedWiremockInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

