/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.spring;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class DependsOnPostProcessor
implements BeanFactoryPostProcessor {
    final Class<?> beansOfType;
    final String[] dependsOn;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        List<String> beanNamesForType = DependsOnPostProcessor.asList(this.getBeanNamesForType(beanFactory));
        beanNamesForType.forEach(dataSourceBeanName -> this.setupDependsOn(beanFactory, (String)dataSourceBeanName));
    }

    private void setupDependsOn(ConfigurableListableBeanFactory beanFactory, String dataSourceBeanName) {
        BeanDefinition dataSourceBeanDefinition = beanFactory.getBeanDefinition(dataSourceBeanName);
        List<String> dependsOnExisting = DependsOnPostProcessor.asList(dataSourceBeanDefinition.getDependsOn());
        dependsOnExisting.addAll(DependsOnPostProcessor.asList(this.dependsOn));
        dataSourceBeanDefinition.setDependsOn(dependsOnExisting.toArray(new String[0]));
    }

    private String[] getBeanNamesForType(ConfigurableListableBeanFactory beanFactory) {
        boolean includeNonSingletons = true;
        boolean allowEagerInit = true;
        return beanFactory.getBeanNamesForType(this.beansOfType, includeNonSingletons, allowEagerInit);
    }

    private static List<String> asList(String[] array) {
        return array == null ? new ArrayList() : Arrays.asList(array);
    }

    @ConstructorProperties(value={"beansOfType", "dependsOn"})
    public DependsOnPostProcessor(Class<?> beansOfType, String[] dependsOn) {
        this.beansOfType = beansOfType;
        this.dependsOn = dependsOn;
    }
}

