/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;

public final class ContainerUtils {
    public static final Duration DEFAULT_CONTAINER_WAIT_DURATION = Duration.ofSeconds(60L);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailableMappingPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find available port for mapping: " + e.getMessage(), e);
        }
    }

    public static Consumer<OutputFrame> containerLogsConsumer(Logger log) {
        return outputFrame -> {
            switch (outputFrame.getType()) {
                case STDERR: {
                    log.debug(outputFrame.getUtf8String());
                    break;
                }
                case STDOUT: 
                case END: {
                    log.debug(outputFrame.getUtf8String());
                    break;
                }
                default: {
                    log.debug(outputFrame.getUtf8String());
                }
            }
        };
    }

    public static String getContainerHostname(GenericContainer container) {
        InspectContainerResponse containerInfo = container.getContainerInfo();
        if (containerInfo == null) {
            containerInfo = container.getDockerClient().inspectContainerCmd(container.getContainerId()).exec();
        }
        return containerInfo.getConfig().getHostName();
    }

    public static ExecCmdResult execCmd(DockerClient dockerClient, String containerId, String[] command) {
        String cmdStderr;
        String cmdStdout;
        ExecCreateCmdResponse cmd = (ExecCreateCmdResponse)dockerClient.execCreateCmd(containerId).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withCmd(command).exec();
        try (ByteArrayOutputStream stdout = new ByteArrayOutputStream();
             ByteArrayOutputStream stderr = new ByteArrayOutputStream();
             ExecStartResultCallback cmdCallback = new ExecStartResultCallback((OutputStream)stdout, (OutputStream)stderr);){
            ((ExecStartResultCallback)dockerClient.execStartCmd(cmd.getId()).exec((ResultCallback)cmdCallback)).awaitCompletion();
            cmdStdout = stdout.toString(StandardCharsets.UTF_8.name());
            cmdStderr = stderr.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            String format = String.format("Exception was thrown when executing: %s, for container: %s ", Arrays.toString(command), containerId);
            throw new IllegalStateException(format, e);
        }
        int exitCode = dockerClient.inspectExecCmd(cmd.getId()).exec().getExitCode();
        String output = cmdStdout.isEmpty() ? cmdStderr : cmdStdout;
        return new ExecCmdResult(exitCode, output);
    }

    private ContainerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class ExecCmdResult {
        private final int exitCode;
        private final String output;

        public ExecCmdResult(int exitCode, String output) {
            this.exitCode = exitCode;
            this.output = output;
        }

        private ExecCmdResult() {
            this.exitCode = 0;
            this.output = null;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public String getOutput() {
            return this.output;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecCmdResult)) {
                return false;
            }
            ExecCmdResult other = (ExecCmdResult)o;
            if (this.getExitCode() != other.getExitCode()) {
                return false;
            }
            String this$output = this.getOutput();
            String other$output = other.getOutput();
            return !(this$output == null ? other$output != null : !this$output.equals(other$output));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExitCode();
            String $output = this.getOutput();
            result = result * 59 + ($output == null ? 43 : $output.hashCode());
            return result;
        }

        public String toString() {
            return "ContainerUtils.ExecCmdResult(exitCode=" + this.getExitCode() + ", output=" + this.getOutput() + ")";
        }
    }
}

