/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class DependsOnPostProcessor
implements BeanFactoryPostProcessor {
    final Class<?> beansOfType;
    final String[] dependsOn;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        List<String> beanNamesForType = DependsOnPostProcessor.asList(this.getBeanNamesForType(beanFactory));
        beanNamesForType.forEach(datastoreClientBeanName -> this.setupDependsOn(beanFactory, (String)datastoreClientBeanName));
    }

    private void setupDependsOn(ConfigurableListableBeanFactory beanFactory, String dataSourceBeanName) {
        BeanDefinition dataStoreClientBeanDefinition = beanFactory.getBeanDefinition(dataSourceBeanName);
        List<String> dependsOnExisting = DependsOnPostProcessor.asList(dataStoreClientBeanDefinition.getDependsOn());
        dependsOnExisting.addAll(DependsOnPostProcessor.asList(this.dependsOn));
        dependsOnExisting.add("allContainers");
        dataStoreClientBeanDefinition.setDependsOn(dependsOnExisting.toArray(new String[0]));
    }

    private String[] getBeanNamesForType(ConfigurableListableBeanFactory beanFactory) {
        boolean includeNonSingletons = true;
        boolean allowEagerInit = true;
        return beanFactory.getBeanNamesForType(this.beansOfType, includeNonSingletons, allowEagerInit);
    }

    private static List<String> asList(String[] array) {
        return array == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(array));
    }

    public DependsOnPostProcessor(Class<?> beansOfType, String[] dependsOn) {
        this.beansOfType = beansOfType;
        this.dependsOn = dependsOn;
    }
}

