/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public final class FileUtils {
    public static void resolveTemplate(ResourceLoader resourceLoader, String fileName, Function<String, String> modifyFunc) throws Exception {
        String fileTemplateContent = FileUtils.getFileContent(resourceLoader, fileName + ".template");
        String modifiedFile = modifyFunc.apply(fileTemplateContent);
        FileUtils.writeToFileInClassesDir(modifiedFile, fileName);
    }

    public static void writeToFileInClassesDir(String body, String fileName) throws Exception {
        Path filePath = Paths.get(FileUtils.class.getClassLoader().getResource("").toURI()).resolve(fileName);
        if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        }
        Files.write(filePath, body.getBytes(), new OpenOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getFileContent(ResourceLoader resourceLoader, String fileName) {
        Resource resource = resourceLoader.getResource(fileName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot read resource: %s", resource.getDescription()), e);
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

