/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.operations;

import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.utils.ThrowingRunnable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class DefaultNetworkTestOperations
implements NetworkTestOperations {
    private final GenericContainer targetContainer;

    @Override
    public void addNetworkLatencyForResponses(Duration delay) {
        this.executeCommandInContainer(container -> {
            try {
                return container.execInContainer(new String[]{"tc", "qdisc", "add", "dev", "eth0", "root", "netem", "delay", delay.toMillis() + "ms"});
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute command", e);
            }
        });
    }

    @Override
    public void removeNetworkLatencyForResponses() {
        this.executeCommandInContainer(container -> {
            try {
                return container.execInContainer(new String[]{"tc", "qdisc", "del", "dev", "eth0", "root"});
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute command", e);
            }
        });
    }

    @Override
    public void withNetworkLatency(Duration delay, ThrowingRunnable runnable) {
        try {
            this.addNetworkLatencyForResponses(delay);
            runnable.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.removeNetworkLatencyForResponses();
        }
    }

    @Override
    public <T> T withNetworkLatency(Duration delay, Callable<T> callable) {
        try {
            this.addNetworkLatencyForResponses(delay);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.removeNetworkLatencyForResponses();
        }
    }

    private void executeCommandInContainer(Function<Container<?>, Container.ExecResult> command) {
        Container.ExecResult execResult = command.apply((Container<?>)this.targetContainer);
        if (!execResult.getStderr().isEmpty()) {
            throw new IllegalStateException("Failed to execute command with message: " + execResult.getStderr());
        }
    }

    public DefaultNetworkTestOperations(GenericContainer targetContainer) {
        this.targetContainer = targetContainer;
    }
}

