/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.checks;

import com.playtika.test.common.checks.AbstractRetryingWaitStrategy;
import com.playtika.test.common.utils.ContainerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;

public abstract class AbstractCommandWaitStrategy
extends AbstractRetryingWaitStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractCommandWaitStrategy.class);

    public abstract String[] getCheckCommand();

    @Override
    protected boolean isReady() {
        String commandName = this.getContainerType();
        String containerId = this.waitStrategyTarget.getContainerId();
        log.debug("{} execution of command {} for container id: {} ", (Object)commandName, (Object)containerId);
        ContainerUtils.ExecCmdResult healthCheckCmdResult = ContainerUtils.execCmd(DockerClientFactory.instance().client(), containerId, this.getCheckCommand());
        log.debug("{} executed with exitCode: {}, output: {}", new Object[]{commandName, healthCheckCmdResult.getExitCode(), healthCheckCmdResult.getOutput()});
        if (healthCheckCmdResult.getExitCode() != 0) {
            log.debug("{} executed with exitCode !=0, considering status as unknown", (Object)commandName);
            return false;
        }
        log.debug("{} command executed, considering container {} successfully started", (Object)commandName, (Object)containerId);
        return true;
    }
}

