/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.UnaryOperator;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;

public final class FileUtils {
    public static String resolveTemplateAsString(ResourceLoader resourceLoader, String fileName, UnaryOperator<String> modifyFunc) {
        String fileTemplateContent = FileUtils.getFileContent(resourceLoader, fileName + ".template");
        return (String)modifyFunc.apply(fileTemplateContent);
    }

    public static Path resolveTemplateAsPath(ResourceLoader resourceLoader, String fileName, UnaryOperator<String> modifyFunc) throws IOException {
        String modifiedFile = FileUtils.resolveTemplateAsString(resourceLoader, fileName, modifyFunc);
        Path tempFilePath = Files.createTempFile("tc_", "_" + fileName, new FileAttribute[0]);
        tempFilePath.toFile().deleteOnExit();
        Files.write(tempFilePath, modifiedFile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return tempFilePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContent(ResourceLoader resourceLoader, String fileName) {
        Resource resource = resourceLoader.getResource(fileName);
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot read resource: %s", resource.getDescription()), e);
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

