/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.properties;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.validation.annotation.Validated;

@Validated
public class CommonContainerProperties {
    private long waitTimeoutInSeconds = 60L;
    private boolean enabled = true;
    private boolean reuseContainer = false;
    private String[] command;
    private Map<String, String> env = Collections.emptyMap();
    @Valid
    private List<CopyFileProperties> filesToInclude = Collections.emptyList();

    public Duration getTimeoutDuration() {
        return Duration.ofSeconds(this.waitTimeoutInSeconds);
    }

    public long getWaitTimeoutInSeconds() {
        return this.waitTimeoutInSeconds;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isReuseContainer() {
        return this.reuseContainer;
    }

    public String[] getCommand() {
        return this.command;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public List<CopyFileProperties> getFilesToInclude() {
        return this.filesToInclude;
    }

    public void setWaitTimeoutInSeconds(long waitTimeoutInSeconds) {
        this.waitTimeoutInSeconds = waitTimeoutInSeconds;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public void setFilesToInclude(List<CopyFileProperties> filesToInclude) {
        this.filesToInclude = filesToInclude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonContainerProperties)) {
            return false;
        }
        CommonContainerProperties other = (CommonContainerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWaitTimeoutInSeconds() != other.getWaitTimeoutInSeconds()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isReuseContainer() != other.isReuseContainer()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCommand(), other.getCommand())) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        List<CopyFileProperties> this$filesToInclude = this.getFilesToInclude();
        List<CopyFileProperties> other$filesToInclude = other.getFilesToInclude();
        return !(this$filesToInclude == null ? other$filesToInclude != null : !((Object)this$filesToInclude).equals(other$filesToInclude));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonContainerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $waitTimeoutInSeconds = this.getWaitTimeoutInSeconds();
        result = result * 59 + (int)($waitTimeoutInSeconds >>> 32 ^ $waitTimeoutInSeconds);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isReuseContainer() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getCommand());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        List<CopyFileProperties> $filesToInclude = this.getFilesToInclude();
        result = result * 59 + ($filesToInclude == null ? 43 : ((Object)$filesToInclude).hashCode());
        return result;
    }

    public String toString() {
        return "CommonContainerProperties(waitTimeoutInSeconds=" + this.getWaitTimeoutInSeconds() + ", enabled=" + this.isEnabled() + ", reuseContainer=" + this.isReuseContainer() + ", command=" + Arrays.deepToString(this.getCommand()) + ", env=" + this.getEnv() + ", filesToInclude=" + this.getFilesToInclude() + ")";
    }

    public static class CopyFileProperties {
        @NotBlank
        String classpathResource;
        @NotBlank
        String containerPath;

        public String getClasspathResource() {
            return this.classpathResource;
        }

        public String getContainerPath() {
            return this.containerPath;
        }

        public void setClasspathResource(String classpathResource) {
            this.classpathResource = classpathResource;
        }

        public void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CopyFileProperties)) {
                return false;
            }
            CopyFileProperties other = (CopyFileProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$classpathResource = this.getClasspathResource();
            String other$classpathResource = other.getClasspathResource();
            if (this$classpathResource == null ? other$classpathResource != null : !this$classpathResource.equals(other$classpathResource)) {
                return false;
            }
            String this$containerPath = this.getContainerPath();
            String other$containerPath = other.getContainerPath();
            return !(this$containerPath == null ? other$containerPath != null : !this$containerPath.equals(other$containerPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CopyFileProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $classpathResource = this.getClasspathResource();
            result = result * 59 + ($classpathResource == null ? 43 : $classpathResource.hashCode());
            String $containerPath = this.getContainerPath();
            result = result * 59 + ($containerPath == null ? 43 : $containerPath.hashCode());
            return result;
        }

        public String toString() {
            return "CommonContainerProperties.CopyFileProperties(classpathResource=" + this.getClasspathResource() + ", containerPath=" + this.getContainerPath() + ")";
        }
    }
}

