/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.DateUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.ImagePullPolicy;
import org.testcontainers.images.PullPolicy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public final class ContainerUtils {
    private static final Logger log = LoggerFactory.getLogger(ContainerUtils.class);

    public static DockerImageName getDockerImageName(CommonContainerProperties properties) {
        String defaultDockerImage;
        DockerImageName customImage = DockerImageName.parse((String)properties.getDockerImage());
        if (properties.getDockerImageVersion() != null) {
            customImage = customImage.withTag(properties.getDockerImageVersion());
        }
        if ((defaultDockerImage = properties.getDefaultDockerImage()) == null) {
            return customImage;
        }
        DockerImageName defaultImage = DockerImageName.parse((String)defaultDockerImage);
        if (customImage.isCompatibleWith(defaultImage)) {
            return customImage;
        }
        log.warn("Custom Docker image {} configured for the container. Note that it may not be compatible with the default Docker image {}.", (Object)customImage, (Object)defaultImage);
        return customImage.asCompatibleSubstituteFor(defaultImage);
    }

    public static GenericContainer<?> configureCommonsAndStart(GenericContainer<?> container, CommonContainerProperties properties, Logger logger) {
        log.info("Starting container with Docker image: {}", (Object)container.getDockerImageName());
        GenericContainer updatedContainer = container.withStartupTimeout(properties.getTimeoutDuration()).withReuse(properties.isReuseContainer()).withLogConsumer(ContainerUtils.containerLogsConsumer(logger)).withImagePullPolicy(ContainerUtils.resolveImagePullPolicy(properties)).withEnv(properties.getEnv());
        for (CommonContainerProperties.CopyFileProperties fileToCopy : properties.getFilesToInclude()) {
            MountableFile mountableFile = MountableFile.forClasspathResource((String)fileToCopy.getClasspathResource());
            updatedContainer = updatedContainer.withCopyFileToContainer(mountableFile, fileToCopy.getContainerPath());
        }
        for (CommonContainerProperties.MountVolume mountVolume : properties.getMountVolumes()) {
            updatedContainer.addFileSystemBind(mountVolume.getHostPath(), mountVolume.getContainerPath(), mountVolume.getMode());
        }
        for (Capability capability : properties.getCapabilities()) {
            updatedContainer.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withCapAdd(new Capability[]{capability}));
        }
        updatedContainer = properties.getCommand() != null ? updatedContainer.withCommand(properties.getCommand()) : updatedContainer;
        ContainerUtils.startAndLogTime(updatedContainer, logger);
        return updatedContainer;
    }

    private static long startAndLogTime(GenericContainer<?> container, Logger logger) {
        Instant startTime = Instant.now();
        container.start();
        long startupTime = Duration.between(startTime, Instant.now()).toMillis() / 1000L;
        String dockerImageName = container.getDockerImageName();
        String buildDate = ContainerUtils.getBuildDate(container, dockerImageName);
        if (startupTime < 10L) {
            logger.info("{} build {} startup time is {} seconds", new Object[]{dockerImageName, buildDate, startupTime});
        } else if (startupTime < 20L) {
            logger.warn("{} build {} startup time is {} seconds", new Object[]{dockerImageName, buildDate, startupTime});
        } else {
            logger.error("{} build {} startup time is {} seconds", new Object[]{dockerImageName, buildDate, startupTime});
        }
        return startupTime;
    }

    private static String getBuildDate(GenericContainer<?> container, String dockerImageName) {
        String imageResponseCreated = null;
        try {
            InspectImageResponse inspectImageResponse = container.getDockerClient().inspectImageCmd(dockerImageName).exec();
            if (inspectImageResponse != null) {
                imageResponseCreated = inspectImageResponse.getCreated();
                return DateUtils.toDateAndTimeAgo(imageResponseCreated);
            }
            log.error("InspectImageResponse was null");
        }
        catch (NotFoundException e) {
            log.error("Could not get InspectImageResponse", (Throwable)e);
        }
        return imageResponseCreated;
    }

    private static ImagePullPolicy resolveImagePullPolicy(CommonContainerProperties properties) {
        return properties.isUsePullAlwaysPolicy() ? PullPolicy.alwaysPull() : PullPolicy.defaultPolicy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getAvailableMappingPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find available port for mapping: " + e.getMessage(), e);
        }
    }

    public static Consumer<OutputFrame> containerLogsConsumer(Logger log) {
        return outputFrame -> {
            switch (outputFrame.getType()) {
                case STDERR: {
                    log.debug(outputFrame.getUtf8String());
                    break;
                }
                case STDOUT: 
                case END: {
                    log.debug(outputFrame.getUtf8String());
                    break;
                }
                default: {
                    log.debug(outputFrame.getUtf8String());
                }
            }
        };
    }

    public static Container.ExecResult executeInContainer(ContainerState container, String ... command) {
        try {
            return container.execInContainer(command);
        }
        catch (Exception e) {
            String format = String.format("Exception was thrown when executing: %s, for container: %s ", Arrays.toString(command), container.getContainerId());
            throw new IllegalStateException(format, e);
        }
    }

    public static Container.ExecResult executeAndCheckExitCode(ContainerState container, String ... command) {
        try {
            Container.ExecResult execResult = container.execInContainer(command);
            log.debug("Executed command in container: {} with result: {}", (Object)container.getContainerId(), (Object)execResult);
            if (execResult.getExitCode() != 0) {
                throw new IllegalStateException("Failed to execute command. Execution result: " + execResult);
            }
            return execResult;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to execute command in container: " + container.getContainerId(), e);
        }
    }

    private ContainerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

