/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.common.utils;

import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.PackageInstaller;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;

public class YumPackageInstaller
extends PackageInstaller {
    public YumPackageInstaller(InstallPackageProperties properties, GenericContainer container) {
        super(properties, container);
    }

    @Override
    protected boolean shouldInstall(String packageToInstall) {
        Container.ExecResult execResult = this.executeCommandAndCheckExitCode("yum", "list", "installed");
        return !execResult.getStdout().contains(packageToInstall);
    }

    @Override
    protected void install(String packageToInstall) {
        this.executeCommandAndCheckExitCode("yum", "-y", "install", packageToInstall);
    }
}

