/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.common.properties;

import com.github.dockerjava.api.model.Capability;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.testcontainers.containers.BindMode;

@Validated
public abstract class CommonContainerProperties {
    private String dockerImage;
    private String dockerImageVersion;
    private long waitTimeoutInSeconds = 60L;
    private boolean enabled = true;
    private boolean reuseContainer = false;
    private boolean usePullAlwaysPolicy = false;
    private String[] command;
    private boolean attachContainerLog = false;
    private Map<String, String> env = new HashMap<String, String>();
    private Map<String, String> label = new HashMap<String, String>();
    @Valid
    private List<CopyFileProperties> filesToInclude = new ArrayList<CopyFileProperties>();
    @Valid
    private List<MountVolume> mountVolumes = new ArrayList<MountVolume>();
    private List<Integer> additionalPorts = new ArrayList<Integer>();
    private List<Capability> capabilities = new ArrayList<Capability>();
    @Valid
    private TmpFs tmpFs = new TmpFs();

    public Duration getTimeoutDuration() {
        return Duration.ofSeconds(this.waitTimeoutInSeconds);
    }

    public abstract String getDefaultDockerImage();

    @Generated
    public CommonContainerProperties() {
    }

    @Generated
    public String getDockerImage() {
        return this.dockerImage;
    }

    @Generated
    public String getDockerImageVersion() {
        return this.dockerImageVersion;
    }

    @Generated
    public long getWaitTimeoutInSeconds() {
        return this.waitTimeoutInSeconds;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isReuseContainer() {
        return this.reuseContainer;
    }

    @Generated
    public boolean isUsePullAlwaysPolicy() {
        return this.usePullAlwaysPolicy;
    }

    @Generated
    public String[] getCommand() {
        return this.command;
    }

    @Generated
    public boolean isAttachContainerLog() {
        return this.attachContainerLog;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Generated
    public Map<String, String> getLabel() {
        return this.label;
    }

    @Generated
    public List<CopyFileProperties> getFilesToInclude() {
        return this.filesToInclude;
    }

    @Generated
    public List<MountVolume> getMountVolumes() {
        return this.mountVolumes;
    }

    @Generated
    public List<Integer> getAdditionalPorts() {
        return this.additionalPorts;
    }

    @Generated
    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    @Generated
    public TmpFs getTmpFs() {
        return this.tmpFs;
    }

    @Generated
    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    @Generated
    public void setDockerImageVersion(String dockerImageVersion) {
        this.dockerImageVersion = dockerImageVersion;
    }

    @Generated
    public void setWaitTimeoutInSeconds(long waitTimeoutInSeconds) {
        this.waitTimeoutInSeconds = waitTimeoutInSeconds;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    @Generated
    public void setUsePullAlwaysPolicy(boolean usePullAlwaysPolicy) {
        this.usePullAlwaysPolicy = usePullAlwaysPolicy;
    }

    @Generated
    public void setCommand(String[] command) {
        this.command = command;
    }

    @Generated
    public void setAttachContainerLog(boolean attachContainerLog) {
        this.attachContainerLog = attachContainerLog;
    }

    @Generated
    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    @Generated
    public void setLabel(Map<String, String> label) {
        this.label = label;
    }

    @Generated
    public void setFilesToInclude(List<CopyFileProperties> filesToInclude) {
        this.filesToInclude = filesToInclude;
    }

    @Generated
    public void setMountVolumes(List<MountVolume> mountVolumes) {
        this.mountVolumes = mountVolumes;
    }

    @Generated
    public void setAdditionalPorts(List<Integer> additionalPorts) {
        this.additionalPorts = additionalPorts;
    }

    @Generated
    public void setCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
    }

    @Generated
    public void setTmpFs(TmpFs tmpFs) {
        this.tmpFs = tmpFs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonContainerProperties)) {
            return false;
        }
        CommonContainerProperties other = (CommonContainerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWaitTimeoutInSeconds() != other.getWaitTimeoutInSeconds()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isReuseContainer() != other.isReuseContainer()) {
            return false;
        }
        if (this.isUsePullAlwaysPolicy() != other.isUsePullAlwaysPolicy()) {
            return false;
        }
        if (this.isAttachContainerLog() != other.isAttachContainerLog()) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        String this$dockerImageVersion = this.getDockerImageVersion();
        String other$dockerImageVersion = other.getDockerImageVersion();
        if (this$dockerImageVersion == null ? other$dockerImageVersion != null : !this$dockerImageVersion.equals(other$dockerImageVersion)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCommand(), other.getCommand())) {
            return false;
        }
        Map<String, String> this$env = this.getEnv();
        Map<String, String> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        Map<String, String> this$label = this.getLabel();
        Map<String, String> other$label = other.getLabel();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        List<CopyFileProperties> this$filesToInclude = this.getFilesToInclude();
        List<CopyFileProperties> other$filesToInclude = other.getFilesToInclude();
        if (this$filesToInclude == null ? other$filesToInclude != null : !((Object)this$filesToInclude).equals(other$filesToInclude)) {
            return false;
        }
        List<MountVolume> this$mountVolumes = this.getMountVolumes();
        List<MountVolume> other$mountVolumes = other.getMountVolumes();
        if (this$mountVolumes == null ? other$mountVolumes != null : !((Object)this$mountVolumes).equals(other$mountVolumes)) {
            return false;
        }
        List<Integer> this$additionalPorts = this.getAdditionalPorts();
        List<Integer> other$additionalPorts = other.getAdditionalPorts();
        if (this$additionalPorts == null ? other$additionalPorts != null : !((Object)this$additionalPorts).equals(other$additionalPorts)) {
            return false;
        }
        List<Capability> this$capabilities = this.getCapabilities();
        List<Capability> other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        TmpFs this$tmpFs = this.getTmpFs();
        TmpFs other$tmpFs = other.getTmpFs();
        return !(this$tmpFs == null ? other$tmpFs != null : !((Object)this$tmpFs).equals(other$tmpFs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommonContainerProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $waitTimeoutInSeconds = this.getWaitTimeoutInSeconds();
        result = result * 59 + (int)($waitTimeoutInSeconds >>> 32 ^ $waitTimeoutInSeconds);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isReuseContainer() ? 79 : 97);
        result = result * 59 + (this.isUsePullAlwaysPolicy() ? 79 : 97);
        result = result * 59 + (this.isAttachContainerLog() ? 79 : 97);
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        String $dockerImageVersion = this.getDockerImageVersion();
        result = result * 59 + ($dockerImageVersion == null ? 43 : $dockerImageVersion.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCommand());
        Map<String, String> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        Map<String, String> $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        List<CopyFileProperties> $filesToInclude = this.getFilesToInclude();
        result = result * 59 + ($filesToInclude == null ? 43 : ((Object)$filesToInclude).hashCode());
        List<MountVolume> $mountVolumes = this.getMountVolumes();
        result = result * 59 + ($mountVolumes == null ? 43 : ((Object)$mountVolumes).hashCode());
        List<Integer> $additionalPorts = this.getAdditionalPorts();
        result = result * 59 + ($additionalPorts == null ? 43 : ((Object)$additionalPorts).hashCode());
        List<Capability> $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        TmpFs $tmpFs = this.getTmpFs();
        result = result * 59 + ($tmpFs == null ? 43 : ((Object)$tmpFs).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommonContainerProperties(dockerImage=" + this.getDockerImage() + ", dockerImageVersion=" + this.getDockerImageVersion() + ", waitTimeoutInSeconds=" + this.getWaitTimeoutInSeconds() + ", enabled=" + this.isEnabled() + ", reuseContainer=" + this.isReuseContainer() + ", usePullAlwaysPolicy=" + this.isUsePullAlwaysPolicy() + ", command=" + Arrays.deepToString(this.getCommand()) + ", attachContainerLog=" + this.isAttachContainerLog() + ", env=" + String.valueOf(this.getEnv()) + ", label=" + String.valueOf(this.getLabel()) + ", filesToInclude=" + String.valueOf(this.getFilesToInclude()) + ", mountVolumes=" + String.valueOf(this.getMountVolumes()) + ", additionalPorts=" + String.valueOf(this.getAdditionalPorts()) + ", capabilities=" + String.valueOf(this.getCapabilities()) + ", tmpFs=" + String.valueOf(this.getTmpFs()) + ")";
    }

    @Validated
    public static class TmpFs {
        @Valid
        List<TmpFsMount> mounts = new ArrayList<TmpFsMount>();

        @Generated
        public TmpFs(List<TmpFsMount> mounts) {
            this.mounts = mounts;
        }

        @Generated
        public TmpFs() {
        }

        @Generated
        public List<TmpFsMount> getMounts() {
            return this.mounts;
        }

        @Generated
        public void setMounts(List<TmpFsMount> mounts) {
            this.mounts = mounts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TmpFs)) {
                return false;
            }
            TmpFs other = (TmpFs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<TmpFsMount> this$mounts = this.getMounts();
            List<TmpFsMount> other$mounts = other.getMounts();
            return !(this$mounts == null ? other$mounts != null : !((Object)this$mounts).equals(other$mounts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TmpFs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TmpFsMount> $mounts = this.getMounts();
            result = result * 59 + ($mounts == null ? 43 : ((Object)$mounts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CommonContainerProperties.TmpFs(mounts=" + String.valueOf(this.getMounts()) + ")";
        }

        @Validated
        public static class TmpFsMount {
            @NotBlank
            String folder;
            String options = "";

            @Generated
            public TmpFsMount(String folder, String options) {
                this.folder = folder;
                this.options = options;
            }

            @Generated
            public TmpFsMount() {
            }

            @Generated
            public String getFolder() {
                return this.folder;
            }

            @Generated
            public String getOptions() {
                return this.options;
            }

            @Generated
            public void setFolder(String folder) {
                this.folder = folder;
            }

            @Generated
            public void setOptions(String options) {
                this.options = options;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TmpFsMount)) {
                    return false;
                }
                TmpFsMount other = (TmpFsMount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$folder = this.getFolder();
                String other$folder = other.getFolder();
                if (this$folder == null ? other$folder != null : !this$folder.equals(other$folder)) {
                    return false;
                }
                String this$options = this.getOptions();
                String other$options = other.getOptions();
                return !(this$options == null ? other$options != null : !this$options.equals(other$options));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TmpFsMount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $folder = this.getFolder();
                result = result * 59 + ($folder == null ? 43 : $folder.hashCode());
                String $options = this.getOptions();
                result = result * 59 + ($options == null ? 43 : $options.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "CommonContainerProperties.TmpFs.TmpFsMount(folder=" + this.getFolder() + ", options=" + this.getOptions() + ")";
            }
        }
    }

    @Validated
    public static class MountVolume {
        @NotBlank
        String hostPath;
        @NotBlank
        String containerPath;
        @NotNull
        BindMode mode = BindMode.READ_ONLY;

        @Generated
        public MountVolume(String hostPath, String containerPath, BindMode mode) {
            this.hostPath = hostPath;
            this.containerPath = containerPath;
            this.mode = mode;
        }

        @Generated
        public MountVolume() {
        }

        @Generated
        public String getHostPath() {
            return this.hostPath;
        }

        @Generated
        public String getContainerPath() {
            return this.containerPath;
        }

        @Generated
        public BindMode getMode() {
            return this.mode;
        }

        @Generated
        public void setHostPath(String hostPath) {
            this.hostPath = hostPath;
        }

        @Generated
        public void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Generated
        public void setMode(BindMode mode) {
            this.mode = mode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MountVolume)) {
                return false;
            }
            MountVolume other = (MountVolume)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hostPath = this.getHostPath();
            String other$hostPath = other.getHostPath();
            if (this$hostPath == null ? other$hostPath != null : !this$hostPath.equals(other$hostPath)) {
                return false;
            }
            String this$containerPath = this.getContainerPath();
            String other$containerPath = other.getContainerPath();
            if (this$containerPath == null ? other$containerPath != null : !this$containerPath.equals(other$containerPath)) {
                return false;
            }
            BindMode this$mode = this.getMode();
            BindMode other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MountVolume;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hostPath = this.getHostPath();
            result = result * 59 + ($hostPath == null ? 43 : $hostPath.hashCode());
            String $containerPath = this.getContainerPath();
            result = result * 59 + ($containerPath == null ? 43 : $containerPath.hashCode());
            BindMode $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CommonContainerProperties.MountVolume(hostPath=" + this.getHostPath() + ", containerPath=" + this.getContainerPath() + ", mode=" + String.valueOf(this.getMode()) + ")";
        }

        @Generated
        public MountVolume withHostPath(String hostPath) {
            return this.hostPath == hostPath ? this : new MountVolume(hostPath, this.containerPath, this.mode);
        }

        @Generated
        public MountVolume withContainerPath(String containerPath) {
            return this.containerPath == containerPath ? this : new MountVolume(this.hostPath, containerPath, this.mode);
        }

        @Generated
        public MountVolume withMode(BindMode mode) {
            return this.mode == mode ? this : new MountVolume(this.hostPath, this.containerPath, mode);
        }
    }

    @Validated
    public static class CopyFileProperties {
        @NotBlank
        String classpathResource;
        @NotBlank
        String containerPath;

        @Generated
        public CopyFileProperties(String classpathResource, String containerPath) {
            this.classpathResource = classpathResource;
            this.containerPath = containerPath;
        }

        @Generated
        public CopyFileProperties() {
        }

        @Generated
        public String getClasspathResource() {
            return this.classpathResource;
        }

        @Generated
        public String getContainerPath() {
            return this.containerPath;
        }

        @Generated
        public void setClasspathResource(String classpathResource) {
            this.classpathResource = classpathResource;
        }

        @Generated
        public void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CopyFileProperties)) {
                return false;
            }
            CopyFileProperties other = (CopyFileProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$classpathResource = this.getClasspathResource();
            String other$classpathResource = other.getClasspathResource();
            if (this$classpathResource == null ? other$classpathResource != null : !this$classpathResource.equals(other$classpathResource)) {
                return false;
            }
            String this$containerPath = this.getContainerPath();
            String other$containerPath = other.getContainerPath();
            return !(this$containerPath == null ? other$containerPath != null : !this$containerPath.equals(other$containerPath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CopyFileProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $classpathResource = this.getClasspathResource();
            result = result * 59 + ($classpathResource == null ? 43 : $classpathResource.hashCode());
            String $containerPath = this.getContainerPath();
            result = result * 59 + ($containerPath == null ? 43 : $containerPath.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CommonContainerProperties.CopyFileProperties(classpathResource=" + this.getClasspathResource() + ", containerPath=" + this.getContainerPath() + ")";
        }

        @Generated
        public CopyFileProperties withClasspathResource(String classpathResource) {
            return this.classpathResource == classpathResource ? this : new CopyFileProperties(classpathResource, this.containerPath);
        }

        @Generated
        public CopyFileProperties withContainerPath(String containerPath) {
            return this.containerPath == containerPath ? this : new CopyFileProperties(this.classpathResource, containerPath);
        }
    }
}

