/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.helper.api.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.plivo.helper.api.response.account.Account;
import com.plivo.helper.api.response.account.SubAccount;
import com.plivo.helper.api.response.account.SubAccountFactory;
import com.plivo.helper.api.response.application.Application;
import com.plivo.helper.api.response.application.ApplicationFactory;
import com.plivo.helper.api.response.call.BulkCall;
import com.plivo.helper.api.response.call.CDR;
import com.plivo.helper.api.response.call.CDRFactory;
import com.plivo.helper.api.response.call.Call;
import com.plivo.helper.api.response.call.LiveCall;
import com.plivo.helper.api.response.call.LiveCallFactory;
import com.plivo.helper.api.response.carrier.IncomingCarrier;
import com.plivo.helper.api.response.carrier.IncomingCarrierFactory;
import com.plivo.helper.api.response.carrier.OutgoingCarrier;
import com.plivo.helper.api.response.carrier.OutgoingCarrierCreatedResponse;
import com.plivo.helper.api.response.carrier.OutgoingCarrierFactory;
import com.plivo.helper.api.response.carrier.OutgoingCarrierRouting;
import com.plivo.helper.api.response.carrier.OutgoingCarrierRoutingCreatedResponse;
import com.plivo.helper.api.response.carrier.OutgoingCarrierRoutingFactory;
import com.plivo.helper.api.response.conference.Conference;
import com.plivo.helper.api.response.conference.LiveConferenceFactory;
import com.plivo.helper.api.response.endpoint.Endpoint;
import com.plivo.helper.api.response.endpoint.EndpointFactory;
import com.plivo.helper.api.response.message.Message;
import com.plivo.helper.api.response.message.MessageFactory;
import com.plivo.helper.api.response.message.MessageResponse;
import com.plivo.helper.api.response.number.Number;
import com.plivo.helper.api.response.number.NumberGroupFactory;
import com.plivo.helper.api.response.number.NumberResponse;
import com.plivo.helper.api.response.number.NumberSearchFactory;
import com.plivo.helper.api.response.number.PhoneNumberSearchFactory;
import com.plivo.helper.api.response.pricing.PlivoPricing;
import com.plivo.helper.api.response.response.GenericResponse;
import com.plivo.helper.api.response.response.Record;
import com.plivo.helper.exception.PlivoException;
import com.plivo.helper.util.HtmlEntity;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;

public class RestAPI {
    public String AUTH_ID;
    private String AUTH_TOKEN;
    private final String PLIVO_URL = "https://api.plivo.com";
    public String PLIVO_VERSION = "v1";
    private String BaseURI;
    private DefaultHttpClient Client;
    private Gson gson;

    public RestAPI(String auth_id, String auth_token, String version) {
        this.AUTH_ID = auth_id;
        this.AUTH_TOKEN = auth_token;
        this.PLIVO_VERSION = version;
        this.BaseURI = String.format("%s/%s/Account/%s", "https://api.plivo.com", this.PLIVO_VERSION, this.AUTH_ID);
        this.Client = new DefaultHttpClient();
        this.Client.getCredentialsProvider().setCredentials(new AuthScope("api.plivo.com", 443), (Credentials)new UsernamePasswordCredentials(this.AUTH_ID, this.AUTH_TOKEN));
        this.gson = new Gson();
    }

    public String request(String method, String resource, LinkedHashMap<String, String> parameters) throws PlivoException {
        BasicHttpResponse response = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        String json = "";
        try {
            try {
                if (method == "GET") {
                    String getparams = "?";
                    for (Map.Entry<String, String> pair : parameters.entrySet()) {
                        getparams = String.valueOf(getparams) + pair.getKey() + "=" + pair.getValue() + "&";
                    }
                    getparams = getparams.substring(0, getparams.length() - 1);
                    HttpGet httpget = new HttpGet(String.valueOf(this.BaseURI) + resource + getparams);
                    response = this.Client.execute((HttpUriRequest)httpget);
                } else if (method == "POST") {
                    HttpPost httpost = new HttpPost(String.valueOf(this.BaseURI) + resource);
                    Gson gson = new GsonBuilder().serializeNulls().create();
                    StringEntity se = new StringEntity(gson.toJson(parameters), "utf-8");
                    se.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
                    httpost.setEntity((HttpEntity)se);
                    response = this.Client.execute((HttpUriRequest)httpost);
                } else if (method == "DELETE") {
                    HttpDelete httpdelete = new HttpDelete(String.valueOf(this.BaseURI) + resource);
                    response = this.Client.execute((HttpUriRequest)httpdelete);
                }
                Integer serverCode = response.getStatusLine().getStatusCode();
                json = response.getEntity() != null ? this.convertStreamToString(response.getEntity().getContent()).replaceFirst("\\{", String.format("{ \"server_code\": %s, ", serverCode.toString())) : String.format("{\"message\":\"no response\",\"api_id\":\"unknown\", \"server_code\":%s}", serverCode.toString());
            }
            catch (ClientProtocolException e) {
                throw new PlivoException(e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new PlivoException(e.getLocalizedMessage());
            }
            catch (IllegalStateException e) {
                throw new PlivoException(e.getLocalizedMessage());
            }
        }
        finally {
            this.Client.getConnectionManager().shutdown();
        }
        return json;
    }

    private String convertStreamToString(InputStream istream) throws IOException {
        BufferedReader breader = new BufferedReader(new InputStreamReader(istream));
        StringBuilder responseString = new StringBuilder();
        String line = "";
        while ((line = breader.readLine()) != null) {
            responseString.append(line);
        }
        breader.close();
        return responseString.toString();
    }

    private String getKeyValue(LinkedHashMap<String, String> params, String key) throws PlivoException {
        String value = "";
        if (!params.containsKey(key)) {
            throw new PlivoException(String.format("Missing mandatory parameter %s.", key));
        }
        value = params.get(key);
        params.remove(key);
        return value;
    }

    public Account getAccount() throws PlivoException {
        return (Account)this.gson.fromJson(this.request("GET", "/", new LinkedHashMap<String, String>()), Account.class);
    }

    public GenericResponse editAccount(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (GenericResponse)this.gson.fromJson(this.request("POST", "/", parameters), GenericResponse.class);
    }

    public SubAccountFactory getSubaccounts() throws PlivoException {
        return (SubAccountFactory)this.gson.fromJson(this.request("GET", "/Subaccount/", new LinkedHashMap<String, String>()), SubAccountFactory.class);
    }

    public SubAccount getSubaccount(LinkedHashMap<String, String> parameters) throws PlivoException {
        String subauth_id = this.getKeyValue(parameters, "subauth_id");
        return (SubAccount)this.gson.fromJson(this.request("GET", String.format("/Subaccount/%s/", subauth_id), parameters), SubAccount.class);
    }

    public SubAccount createSubaccount(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (SubAccount)this.gson.fromJson(this.request("POST", "/Subaccount/", parameters), SubAccount.class);
    }

    public GenericResponse editSubaccount(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (GenericResponse)this.gson.fromJson(this.request("POST", "/Subaccount/", parameters), GenericResponse.class);
    }

    public GenericResponse deleteSubaccount(LinkedHashMap<String, String> parameters) throws PlivoException {
        String subauth_id = this.getKeyValue(parameters, "subauth_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Subaccount/%s/", subauth_id), parameters), GenericResponse.class);
    }

    public ApplicationFactory getApplications() throws PlivoException {
        return (ApplicationFactory)this.gson.fromJson(this.request("GET", "/Application/", new LinkedHashMap<String, String>()), ApplicationFactory.class);
    }

    public ApplicationFactory getApplications(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (ApplicationFactory)this.gson.fromJson(this.request("GET", "/Application/", parameters), ApplicationFactory.class);
    }

    public Application getApplication(LinkedHashMap<String, String> parameters) throws PlivoException {
        String app_id = this.getKeyValue(parameters, "app_id");
        return (Application)this.gson.fromJson(this.request("GET", String.format("/Application/%s/", app_id), new LinkedHashMap<String, String>()), Application.class);
    }

    public Application createApplication(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (Application)this.gson.fromJson(this.request("POST", "/Application/", parameters), Application.class);
    }

    public GenericResponse editApplication(LinkedHashMap<String, String> parameters) throws PlivoException {
        String app_id = this.getKeyValue(parameters, "app_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Application/%s/", app_id), parameters), GenericResponse.class);
    }

    public GenericResponse deleteApplication(LinkedHashMap<String, String> parameters) throws PlivoException {
        String app_id = this.getKeyValue(parameters, "app_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Application/%s/", app_id), parameters), GenericResponse.class);
    }

    public CDRFactory getCDRs(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (CDRFactory)this.gson.fromJson(this.request("GET", "/Call/", parameters), CDRFactory.class);
    }

    public CDR getCDR(LinkedHashMap<String, String> parameters) throws PlivoException {
        String record_id = this.getKeyValue(parameters, "record_id");
        return (CDR)this.gson.fromJson(this.request("GET", String.format("/Call/%s/", record_id), new LinkedHashMap<String, String>()), CDR.class);
    }

    public LiveCallFactory getLiveCalls() throws PlivoException {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("status", "live");
        return (LiveCallFactory)this.gson.fromJson(this.request("GET", "/Call/", parameters), LiveCallFactory.class);
    }

    public LiveCall getLiveCall(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        parameters.put("status", "live");
        return (LiveCall)this.gson.fromJson(this.request("GET", String.format("/Call/%s/", call_uuid), parameters), LiveCall.class);
    }

    public Call makeCall(LinkedHashMap<String, String> parameters) throws PlivoException {
        String to = parameters.get("to");
        if (to != null && to.indexOf("<") != -1) {
            throw new PlivoException("Use the makeBulkCall() method to make calls to multiple numbers.");
        }
        return (Call)this.gson.fromJson(this.request("POST", "/Call/", parameters), Call.class);
    }

    public BulkCall makeBulkCall(LinkedHashMap<String, String> parameters) throws PlivoException {
        String to = parameters.get("to");
        if (to != null && to.indexOf("<") == -1) {
            throw new PlivoException("Use the makeCall() method to make calls to a single number.");
        }
        return (BulkCall)this.gson.fromJson(this.request("POST", "/Call/", parameters), BulkCall.class);
    }

    public GenericResponse hangupAllCalls() throws PlivoException {
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", "/Call/", new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse hangupCall(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Call/%s/", call_uuid), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse transferCall(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Call/%s/", call_uuid), parameters), GenericResponse.class);
    }

    public Record record(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (Record)this.gson.fromJson(this.request("POST", String.format("/Call/%s/Record/", call_uuid), parameters), Record.class);
    }

    public GenericResponse stopRecord(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Call/%s/Record/", call_uuid), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse play(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Call/%s/Play/", call_uuid), parameters), GenericResponse.class);
    }

    public GenericResponse stopPlay(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Call/%s/Play/", call_uuid), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse speak(LinkedHashMap<String, String> parameters) throws PlivoException {
        String text = HtmlEntity.convert(this.getKeyValue(parameters, "text"));
        parameters.put("text", text);
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Call/%s/Speak/", call_uuid), parameters), GenericResponse.class);
    }

    public GenericResponse stopSpeak(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Call/%s/Speak/", call_uuid), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse sendDigits(LinkedHashMap<String, String> parameters) throws PlivoException {
        String call_uuid = this.getKeyValue(parameters, "call_uuid");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Call/%s/DTMF/", call_uuid), parameters), GenericResponse.class);
    }

    public LiveConferenceFactory getLiveConferences() throws PlivoException {
        return (LiveConferenceFactory)this.gson.fromJson(this.request("GET", "/Conference/", new LinkedHashMap<String, String>()), LiveConferenceFactory.class);
    }

    public GenericResponse hangupAllConferences() throws PlivoException {
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", "/Conference/", new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public Conference getLiveConference(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        return (Conference)this.gson.fromJson(this.request("GET", String.format("/Conference/%s/", conference_name), new LinkedHashMap<String, String>()), Conference.class);
    }

    public GenericResponse hangupConference(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Conference/%s/", conference_name), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse hangupMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String member_id = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Conference/%1$s/Member/%2$s/", conference_name, member_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse playMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String member_id = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Conference/%1$s/Member/%2$s/Play/", conference_name, member_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse stopPlayMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String member_id = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Conference/%1$s/Member/%2$s/Play/", conference_name, member_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse speakMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String text = HtmlEntity.convert(this.getKeyValue(parameters, "text"));
        parameters.put("text", text);
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String member_id = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Conference/%1$s/Member/%2$s/Speak/", conference_name, member_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse deafMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String memberId = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Conference/%1$s/Member/%2$s/Deaf/", conference_name, memberId), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse undeafMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String memberId = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Conference/%1$s/Member/%2$s/Deaf/", conference_name, memberId), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse muteMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String member_id = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Conference/%1$s/Member/%2$s/Mute/", conference_name, member_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse unmuteMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String member_id = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Conference/%1$s/Member/%2$s/Mute/", conference_name, member_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public GenericResponse kickMember(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        String member_id = this.getKeyValue(parameters, "member_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Conference/%1$s/Member/%2$s/Kick/", conference_name, member_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public Record recordConference(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        return (Record)this.gson.fromJson(this.request("POST", String.format("/Conference/%s/Record/", conference_name), parameters), Record.class);
    }

    public GenericResponse stopRecordConference(LinkedHashMap<String, String> parameters) throws PlivoException {
        String conference_name = this.getKeyValue(parameters, "conference_name");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Conference/%s/Record/", conference_name), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public EndpointFactory getEndpoints(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (EndpointFactory)this.gson.fromJson(this.request("GET", "/Endpoint/", parameters), EndpointFactory.class);
    }

    public Endpoint createEndpoint(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (Endpoint)this.gson.fromJson(this.request("POST", "/Endpoint/", parameters), Endpoint.class);
    }

    public Endpoint getEndpoint(LinkedHashMap<String, String> parameters) throws PlivoException {
        String endpoint_id = this.getKeyValue(parameters, "endpoint_id");
        return (Endpoint)this.gson.fromJson(this.request("GET", String.format("/Endpoint/%s/", endpoint_id), new LinkedHashMap<String, String>()), Endpoint.class);
    }

    public GenericResponse editEndpoint(LinkedHashMap<String, String> parameters) throws PlivoException {
        String endpoint_id = this.getKeyValue(parameters, "endpoint_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Endpoint/%s/", endpoint_id), parameters), GenericResponse.class);
    }

    public GenericResponse deleteEndpoint(LinkedHashMap<String, String> parameters) throws PlivoException {
        String endpoint_id = this.getKeyValue(parameters, "endpoint_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Endpoint/%s/", endpoint_id), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public NumberSearchFactory getNumbers() throws PlivoException {
        return (NumberSearchFactory)this.gson.fromJson(this.request("GET", "/Number/", new LinkedHashMap<String, String>()), NumberSearchFactory.class);
    }

    public NumberSearchFactory getNumbers(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (NumberSearchFactory)this.gson.fromJson(this.request("GET", "/Number/", parameters), NumberSearchFactory.class);
    }

    public Number getNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        String number = this.getKeyValue(parameters, "number");
        return (Number)this.gson.fromJson(this.request("GET", String.format("/Number/%s/", number), new LinkedHashMap<String, String>()), Number.class);
    }

    public GenericResponse editNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        String number = this.getKeyValue(parameters, "number");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Number/%s/", number), parameters), GenericResponse.class);
    }

    @Deprecated
    public NumberSearchFactory searchNumbers(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (NumberSearchFactory)this.gson.fromJson(this.request("GET", "/AvailableNumber/", parameters), NumberSearchFactory.class);
    }

    @Deprecated
    public GenericResponse rentNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        String number = this.getKeyValue(parameters, "number");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/AvailableNumber/%s/", number, parameters), new LinkedHashMap<String, String>()), GenericResponse.class);
    }

    public NumberGroupFactory searchNumberGroups(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (NumberGroupFactory)this.gson.fromJson(this.request("GET", "/AvailableNumberGroup/", parameters), NumberGroupFactory.class);
    }

    public NumberResponse rentNumbers(LinkedHashMap<String, String> parameters) throws PlivoException {
        String groupId = this.getKeyValue(parameters, "group_id");
        return (NumberResponse)this.gson.fromJson(this.request("POST", String.format("/AvailableNumberGroup/%s/", groupId), parameters), NumberResponse.class);
    }

    public GenericResponse unRentNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        String number = this.getKeyValue(parameters, "number");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/Number/%s/", number), parameters), GenericResponse.class);
    }

    public GenericResponse linkApplicationNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        String number = this.getKeyValue(parameters, "number");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Number/%s/", number), parameters), GenericResponse.class);
    }

    public GenericResponse unlinkApplicationNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        String number = this.getKeyValue(parameters, "number");
        parameters.put("app_id", "");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/Number/%s/", number), parameters), GenericResponse.class);
    }

    public PhoneNumberSearchFactory searchPhoneNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (PhoneNumberSearchFactory)this.gson.fromJson(this.request("GET", "/PhoneNumber/", parameters), PhoneNumberSearchFactory.class);
    }

    public NumberResponse buyPhoneNumber(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (NumberResponse)this.gson.fromJson(this.request("POST", String.format("/PhoneNumber/%s/", this.getKeyValue(parameters, "number")), parameters), NumberResponse.class);
    }

    public MessageResponse sendMessage(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (MessageResponse)this.gson.fromJson(this.request("POST", "/Message/", parameters), MessageResponse.class);
    }

    public Message getMessage(LinkedHashMap<String, String> parameters) throws PlivoException {
        String record_id = this.getKeyValue(parameters, "record_id");
        return (Message)this.gson.fromJson(this.request("GET", String.format("/Message/%s/", record_id), new LinkedHashMap<String, String>()), Message.class);
    }

    public MessageFactory getMessages() throws PlivoException {
        return (MessageFactory)this.gson.fromJson(this.request("GET", "/Message/", new LinkedHashMap<String, String>()), MessageFactory.class);
    }

    public MessageFactory getMessages(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (MessageFactory)this.gson.fromJson(this.request("GET", "/Message/", parameters), MessageFactory.class);
    }

    public IncomingCarrierFactory getIncomingCarriers(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (IncomingCarrierFactory)this.gson.fromJson(this.request("GET", "/IncomingCarrier/", parameters), IncomingCarrierFactory.class);
    }

    public IncomingCarrier getIncomingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        String carrier = this.getKeyValue(parameters, "carrier_id");
        return (IncomingCarrier)this.gson.fromJson(this.request("GET", String.format("/IncomingCarrier/%s/", carrier), parameters), IncomingCarrier.class);
    }

    public GenericResponse addIncomingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (GenericResponse)this.gson.fromJson(this.request("POST", "/IncomingCarrier/", parameters), GenericResponse.class);
    }

    public GenericResponse editIncomingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        String carrier = this.getKeyValue(parameters, "carrier_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/IncomingCarrier/", carrier), parameters), GenericResponse.class);
    }

    public GenericResponse dropIncomingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        String carrier = this.getKeyValue(parameters, "carrier_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/IncomingCarrier/%s/", carrier), parameters), GenericResponse.class);
    }

    public OutgoingCarrierFactory getOutgoingCarriers(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (OutgoingCarrierFactory)this.gson.fromJson(this.request("GET", "/OutgoingCarrier/", parameters), OutgoingCarrierFactory.class);
    }

    public OutgoingCarrier getOutgoingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        String carrier = this.getKeyValue(parameters, "carrier_id");
        return (OutgoingCarrier)this.gson.fromJson(this.request("GET", String.format("/OutgoingCarrier/%s/", carrier), parameters), OutgoingCarrier.class);
    }

    public OutgoingCarrierCreatedResponse addOutgoingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (OutgoingCarrierCreatedResponse)this.gson.fromJson(this.request("POST", "/OutgoingCarrier/", parameters), OutgoingCarrierCreatedResponse.class);
    }

    public GenericResponse editOutgoingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        String carrier = this.getKeyValue(parameters, "carrier_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/OutgoingCarrier/%s/", carrier), parameters), GenericResponse.class);
    }

    public GenericResponse dropOutgoingCarrier(LinkedHashMap<String, String> parameters) throws PlivoException {
        String carrier = this.getKeyValue(parameters, "carrier_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/OutgoingCarrier/%s/", carrier), parameters), GenericResponse.class);
    }

    public OutgoingCarrierRoutingFactory getOutgoingCarrierRoutings(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (OutgoingCarrierRoutingFactory)this.gson.fromJson(this.request("GET", "/OutgoingCarrierRouting/", parameters), OutgoingCarrierRoutingFactory.class);
    }

    public OutgoingCarrierRouting getOutgoingCarrierRouting(LinkedHashMap<String, String> parameters) throws PlivoException {
        String carrier = this.getKeyValue(parameters, "routing_id");
        return (OutgoingCarrierRouting)this.gson.fromJson(this.request("GET", String.format("/OutgoingCarrierRouting/%s/", carrier), parameters), OutgoingCarrierRouting.class);
    }

    public OutgoingCarrierRoutingCreatedResponse addOutgoingCarrierRouting(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (OutgoingCarrierRoutingCreatedResponse)this.gson.fromJson(this.request("POST", "/OutgoingCarrierRouting/", parameters), OutgoingCarrierRoutingCreatedResponse.class);
    }

    public GenericResponse editOutgoingCarrierRouting(LinkedHashMap<String, String> parameters) throws PlivoException {
        String routing_id = this.getKeyValue(parameters, "routing_id");
        return (GenericResponse)this.gson.fromJson(this.request("POST", String.format("/OutgoingCarrierRouting/%s/", routing_id), parameters), GenericResponse.class);
    }

    public GenericResponse dropOutgoingCarrierRouting(LinkedHashMap<String, String> parameters) throws PlivoException {
        String routing_id = this.getKeyValue(parameters, "routing_id");
        return (GenericResponse)this.gson.fromJson(this.request("DELETE", String.format("/OutgoingCarrierRouting/%s/", routing_id), parameters), GenericResponse.class);
    }

    public PlivoPricing getPricing(LinkedHashMap<String, String> parameters) throws PlivoException {
        return (PlivoPricing)this.gson.fromJson(this.request("GET", "/Pricing/", parameters), PlivoPricing.class);
    }
}

