/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.helper.util;

import com.plivo.helper.exception.PlivoException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class XPlivoSignature {
    public static Boolean verify(String uri, LinkedHashMap<String, String> parameters, String xsignature, String authToken) throws PlivoException {
        Boolean isMatch = false;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(parameters);
        for (Map.Entry pair : sortedParams.entrySet()) {
            uri = String.valueOf(uri) + (String)pair.getKey() + (String)pair.getValue();
        }
        try {
            byte[] keyBytes = authToken.getBytes();
            byte[] textBytes = uri.getBytes();
            Mac hmac = Mac.getInstance("HmacSHA1");
            SecretKeySpec macKey = new SecretKeySpec(keyBytes, "HmacSHA1");
            hmac.init(macKey);
            byte[] signBytes = hmac.doFinal(textBytes);
            String signature = new String(Base64.encodeBase64((byte[])signBytes));
            if (signature.equals(xsignature)) {
                isMatch = true;
            }
        }
        catch (Exception e) {
            throw new PlivoException(e.getLocalizedMessage());
        }
        return isMatch;
    }
}

