/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.helper.xml.elements;

import com.plivo.helper.exception.PlivoException;
import java.util.ArrayList;
import java.util.HashMap;

public class PlivoElement {
    protected String tag;
    protected String body;
    protected HashMap<String, String> attributes;
    protected ArrayList<PlivoElement> childTags;
    protected ArrayList<String> nestableElements;
    public static final String E_RESPONSE = "Response";
    public static final String E_CONFERENCE = "Conference";
    public static final String E_DIAL = "Dial";
    public static final String E_NUMBER = "Number";
    public static final String E_USER = "User";
    public static final String E_GETDIGITS = "GetDigits";
    public static final String E_HANGUP = "Hangup";
    public static final String E_MESSAGE = "Message";
    public static final String E_PLAY = "Play";
    public static final String E_PREANSWER = "PreAnswer";
    public static final String E_RECORD = "Record";
    public static final String E_REDIRECT = "Redirect";
    public static final String E_SPEAK = "Speak";
    public static final String E_WAIT = "Wait";
    public static final String E_DTMF = "DTMF";

    public PlivoElement(String tag, String body) {
        this.tag = tag;
        this.body = body;
        this.attributes = new HashMap();
        this.childTags = new ArrayList();
    }

    public PlivoElement append(PlivoElement element) throws PlivoException {
        if (this.nestableElements != null && this.nestableElements.contains(element.getTag())) {
            this.childTags.add(element);
            return element;
        }
        throw new PlivoException(String.format("<%1s> is not nestable in <%2s>.", element.getTag(), this.getTag()));
    }

    public String toXML() {
        String xml = "<" + this.tag;
        for (String key : this.attributes.keySet()) {
            xml = String.valueOf(xml) + " " + key + "=\"" + this.attributes.get(key) + "\"";
        }
        if (this.body != null) {
            xml = String.valueOf(xml) + ">" + this.body + "</" + this.tag + ">";
        } else if (!this.childTags.isEmpty()) {
            xml = String.valueOf(xml) + ">";
            for (PlivoElement child : this.childTags) {
                xml = String.valueOf(xml) + child.toXML();
            }
            xml = String.valueOf(xml) + "</" + this.tag + ">";
        } else {
            xml = String.valueOf(xml) + "/>";
        }
        return xml;
    }

    public void set(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getBody() {
        return this.body;
    }

    public String getTag() {
        return this.tag;
    }

    public ArrayList<PlivoElement> getChildren() {
        return this.childTags;
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }
}

