/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.plivo.api.PlivoAPIService;
import com.plivo.api.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ProtocolException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class PlivoClient {
    private static SimpleModule simpleModule = new SimpleModule();
    protected static String BASE_URL = "https://api.plivo.com/v1/";
    private static String version = "Unknown Version";
    private boolean testing = false;
    private static ObjectMapper objectMapper = new ObjectMapper();
    private final Interceptor interceptor;
    private final String authId;
    private final String authToken;
    private OkHttpClient httpClient;
    private Retrofit retrofit;
    private PlivoAPIService apiService;

    public void setTesting(boolean testing) {
        this.testing = testing;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public PlivoClient(String authId, String authToken, OkHttpClient.Builder httpClientBuilder, String baseUrl, SimpleModule simpleModule) {
        try {
            InputStream inputStream = PlivoClient.class.getResource("version.txt").openStream();
            version = new BufferedReader(new InputStreamReader(inputStream)).readLine();
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        this.interceptor = new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY);
        this.apiService = null;
        if (!Utils.isAccountIdValid(authId) && !Utils.isSubaccountIdValid(authId)) {
            throw new IllegalArgumentException("invalid account ID");
        }
        this.authId = authId;
        this.authToken = authToken;
        objectMapper.registerModule((Module)simpleModule);
        this.httpClient = httpClientBuilder.addNetworkInterceptor(this.interceptor).addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", Credentials.basic((String)this.getAuthId(), (String)this.getAuthToken())).addHeader("User-Agent", String.format("%s/%s (Implementation: %s %s %s, Specification: %s %s %s)", "plivo-java", version, Runtime.class.getPackage().getImplementationVendor(), Runtime.class.getPackage().getImplementationTitle(), Runtime.class.getPackage().getImplementationVersion(), Runtime.class.getPackage().getSpecificationVendor(), Runtime.class.getPackage().getSpecificationTitle(), Runtime.class.getPackage().getSpecificationVersion())).build())).addNetworkInterceptor(chain -> {
            Response response;
            try {
                response = chain.proceed(chain.request());
            }
            catch (ProtocolException protocolException) {
                response = new Response.Builder().request(chain.request()).code(204).protocol(Protocol.HTTP_1_1).body(ResponseBody.create(null, (byte[])new byte[0])).build();
            }
            return response;
        }).build();
        this.retrofit = new Retrofit.Builder().client(this.httpClient).baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).build();
        this.apiService = (PlivoAPIService)this.retrofit.create(PlivoAPIService.class);
    }

    public PlivoClient(String authId, String authToken) {
        this(authId, authToken, new OkHttpClient.Builder(), BASE_URL, simpleModule);
    }

    public PlivoClient(String authId, String authToken, OkHttpClient.Builder httpClientBuilder) {
        this(authId, authToken, httpClientBuilder, BASE_URL, simpleModule);
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    Retrofit getRetrofit() {
        return this.retrofit;
    }

    public PlivoAPIService getApiService() {
        return this.apiService;
    }

    void setApiService(PlivoAPIService apiService) {
        this.apiService = apiService;
    }

    public String getAuthId() {
        return this.authId;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    static {
        simpleModule.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyEnumDeserializer(DeserializationConfig config, final JavaType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                return new JsonDeserializer<Enum>(){

                    public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                        Class rawClass = type.getRawClass();
                        return Enum.valueOf(rawClass, jp.getValueAsString().toUpperCase().replace("-", "_"));
                    }
                };
            }
        });
        simpleModule.addSerializer(Enum.class, (JsonSerializer)new StdSerializer<Enum>(Enum.class){

            public void serialize(Enum value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(value.name().toLowerCase().replace("_", "-"));
            }
        });
    }
}

