/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.plivo.api.Plivo;
import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.AuthenticationException;
import com.plivo.api.exceptions.InvalidRequestException;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.ResourceNotFoundException;
import com.plivo.api.exceptions.ServerException;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.base.Deleter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import okhttp3.ResponseBody;
import retrofit2.Response;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public abstract class BaseRequest<T extends BaseResource> {
    @JsonIgnore
    protected PlivoClient plivoClient = Plivo.getClient();

    public PlivoClient client() {
        return this.plivoClient;
    }

    public BaseRequest client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    protected void validate() {
        if (this.plivoClient == null) {
            throw new IllegalStateException("client cannot be null");
        }
        if (this.plivoClient.isTesting()) {
            String methodName;
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Method method : this.getClass().getMethods()) {
                if (method.getParameterCount() != 0) continue;
                methodName = method.getName();
                try {
                    this.getClass().getDeclaredField(methodName);
                    values.put(methodName, method.invoke((Object)this, new Object[0]));
                }
                catch (IllegalAccessException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            for (Method method : this.getClass().getMethods()) {
                if (method.getParameterCount() != 1) continue;
                methodName = method.getName();
                try {
                    this.getClass().getDeclaredField(methodName);
                    Object value = values.get(methodName);
                    method.invoke((Object)this, value);
                }
                catch (IllegalAccessException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void handleResponse(Response response) throws PlivoRestException, IOException {
        if (this.plivoClient.isTesting() && response.body() != null) {
            if (!(response.body() instanceof ResponseBody)) {
                this.client();
                PlivoClient.getObjectMapper().convertValue(response.body(), JsonNode.class);
            }
            response.body().toString();
        }
        int responseCode = response.code();
        switch (responseCode) {
            case 400: {
                throw new InvalidRequestException(response.errorBody().string());
            }
            case 401: {
                throw new AuthenticationException(response.errorBody().string());
            }
            case 404: {
                throw new ResourceNotFoundException(response.errorBody().string());
            }
            case 405: {
                throw new InvalidRequestException(response.errorBody().string());
            }
            case 500: {
                throw new ServerException(response.errorBody().string());
            }
        }
        if (this instanceof Deleter && responseCode != 204) {
            throw new PlivoRestException(response.errorBody().string());
        }
        if (!response.isSuccessful()) {
            throw new PlivoRestException(response.errorBody().string());
        }
    }
}

