/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.models.base.BaseRequest;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.util.Utils;
import java.io.IOException;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public abstract class Getter<T extends BaseResource>
extends BaseRequest<T> {
    protected final String id;

    public Getter(String id) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
    }

    public T get() throws IOException, PlivoRestException {
        this.validate();
        Response response = this.obtainCall().execute();
        this.handleResponse(response);
        return (T)((BaseResource)response.body());
    }

    @Override
    public Getter<T> client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    protected Map<String, Object> toMap() {
        this.client();
        return Utils.objectToMap(PlivoClient.getObjectMapper(), this);
    }

    protected abstract Call<T> obtainCall();
}

