/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.call;

import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.call.CallCreator;
import com.plivo.api.models.call.CallDeleter;
import com.plivo.api.models.call.CallDirection;
import com.plivo.api.models.call.CallGetter;
import com.plivo.api.models.call.CallLister;
import com.plivo.api.models.call.CallUpdater;
import com.plivo.api.models.call.RequestDeleter;
import com.plivo.api.models.call.actions.CallDtmfCreator;
import com.plivo.api.models.call.actions.CallPlayCreator;
import com.plivo.api.models.call.actions.CallPlayDeleter;
import com.plivo.api.models.call.actions.CallRecordCreator;
import com.plivo.api.models.call.actions.CallRecordDeleter;
import com.plivo.api.models.call.actions.CallSpeakCreator;
import com.plivo.api.models.call.actions.CallSpeakDeleter;
import java.util.List;

public class Call
extends BaseResource {
    private String answerTime;
    private Long billDuration;
    private Long billedDuration;
    private CallDirection callDirection;
    private Long callDuration;
    private String callState;
    private String callUuid;
    private String endTime;
    private String fromNumber;
    private String initiationTime;
    private String parentCallUuid;
    private String resourceUri;
    private String toNumber;
    private String totalAmount;
    private String totalRate;
    private String hangupSource;
    private String hangupCauseName;
    private Integer hangupCauseCode;

    public static CallCreator creator(String from, List<String> to, String answerUrl) {
        return new CallCreator(from, to, answerUrl);
    }

    public static CallDeleter deleter(String id) {
        return new CallDeleter(id);
    }

    public static CallUpdater updater(String id) {
        return new CallUpdater(id);
    }

    public static CallUpdater transferrer(String id) {
        return new CallUpdater(id);
    }

    public static CallLister lister() {
        return new CallLister();
    }

    public static CallRecordCreator recorder(String callUuid) {
        return new CallRecordCreator(callUuid);
    }

    public static CallRecordDeleter recordStopper(String callUuid) {
        return new CallRecordDeleter(callUuid);
    }

    public static CallPlayCreator player(String callUuid, List<String> urls) {
        return new CallPlayCreator(callUuid, urls);
    }

    public static CallPlayDeleter playStopper(String callUuid) {
        return new CallPlayDeleter(callUuid);
    }

    public static CallSpeakCreator speaker(String callUuid, String text) {
        return new CallSpeakCreator(callUuid, text);
    }

    public static CallSpeakDeleter speakStopper(String callUuid) {
        return new CallSpeakDeleter(callUuid);
    }

    public static CallDtmfCreator digitSender(String callUuid, String digits) {
        return new CallDtmfCreator(callUuid, digits);
    }

    public static CallGetter getter(String id) {
        return new CallGetter(id);
    }

    public String getAnswerTime() {
        return this.answerTime;
    }

    public Long getBillDuration() {
        return this.billDuration;
    }

    public Long getBilledDuration() {
        return this.billedDuration;
    }

    public CallDirection getCallDirection() {
        return this.callDirection;
    }

    public Long getCallDuration() {
        return this.callDuration;
    }

    public String getcallState() {
        return this.callState;
    }

    public String getCallUuid() {
        return this.callUuid;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getFromNumber() {
        return this.fromNumber;
    }

    public String getInitiationTime() {
        return this.initiationTime;
    }

    public String getParentCallUuid() {
        return this.parentCallUuid;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getToNumber() {
        return this.toNumber;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public String getTotalRate() {
        return this.totalRate;
    }

    public String getHangupCauseName() {
        return this.hangupCauseName;
    }

    public String getHangupSource() {
        return this.hangupSource;
    }

    public Integer getHangupCauseCode() {
        return this.hangupCauseCode;
    }

    public CallDeleter deleter() {
        return Call.deleter(this.callUuid);
    }

    public CallUpdater updater() {
        return Call.updater(this.callUuid);
    }

    public CallUpdater transferrer() {
        return Call.updater(this.callUuid);
    }

    public CallRecordCreator recorder() {
        return new CallRecordCreator(this.callUuid);
    }

    public CallRecordDeleter recordStopper() {
        return new CallRecordDeleter(this.callUuid);
    }

    public CallPlayCreator player(List<String> urls) {
        return new CallPlayCreator(this.callUuid, urls);
    }

    public CallPlayDeleter playStopper() {
        return new CallPlayDeleter(this.callUuid);
    }

    public CallSpeakCreator speaker(String text) {
        return new CallSpeakCreator(this.callUuid, text);
    }

    public RequestDeleter canceller() {
        return Call.canceller(this.callUuid);
    }

    public static RequestDeleter canceller(String callUuid) {
        return new RequestDeleter(callUuid);
    }

    public CallSpeakDeleter speakStopper() {
        return new CallSpeakDeleter(this.callUuid);
    }

    public CallDtmfCreator digitSender(String digits) {
        return new CallDtmfCreator(this.callUuid, digits);
    }

    @Override
    public String getId() {
        return this.getCallUuid();
    }
}

