/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.call;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.plivo.api.models.base.Creator;
import com.plivo.api.models.call.CallCreateResponse;
import com.plivo.api.serializers.MapToCommaListSerializer;
import com.plivo.api.util.Utils;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class CallCreator
extends Creator<CallCreateResponse> {
    private String from;
    private List<String> to;
    private String answerUrl;
    private String answerMethod;
    private String ringUrl;
    private String ringMethod;
    private String hangupUrl;
    private String hangupMethod;
    private String fallbackUrl;
    private String fallbackMethod;
    private String callbackUrl;
    private String callbackMethod;
    private String callerName;
    private String sendDigits;
    private Boolean sendOnPreanswer;
    private Long timeLimit;
    private Long hangupOnRing;
    private String machineDetection;
    private Long machineDetectionTime;
    private String machineDetectionUrl;
    private String machineDetectionMethod;
    @JsonSerialize(using=MapToCommaListSerializer.class)
    private Map<String, String> sipHeaders;
    private Long ringTimeout;
    private String parentCallUuid;
    private Boolean errorIfParentNotFound;

    CallCreator(String from, List<String> to, String answerUrl) {
        if (!Utils.allNotNull(from, to, answerUrl)) {
            throw new IllegalArgumentException("from, to and answerUrl must not be null");
        }
        if (to.isEmpty()) {
            throw new IllegalArgumentException("to cannot be empty");
        }
        this.from = from;
        this.to = to;
        this.answerUrl = answerUrl;
    }

    public String from() {
        return this.from;
    }

    public List<String> to() {
        return this.to;
    }

    public String answerUrl() {
        return this.answerUrl;
    }

    public String answerMethod() {
        return this.answerMethod;
    }

    public String ringUrl() {
        return this.ringUrl;
    }

    public String ringMethod() {
        return this.ringMethod;
    }

    public String hangupUrl() {
        return this.hangupUrl;
    }

    public String hangupMethod() {
        return this.hangupMethod;
    }

    public String fallbackUrl() {
        return this.fallbackUrl;
    }

    public String callbackUrl() {
        return this.callbackUrl;
    }

    public String fallbackMethod() {
        return this.fallbackMethod;
    }

    public String callbackMethod() {
        return this.callbackMethod;
    }

    public String callerName() {
        return this.callerName;
    }

    public String sendDigits() {
        return this.sendDigits;
    }

    public Boolean sendOnPreanswer() {
        return this.sendOnPreanswer;
    }

    public Long timeLimit() {
        return this.timeLimit;
    }

    public Long hangupOnRing() {
        return this.hangupOnRing;
    }

    public String machineDetection() {
        return this.machineDetection;
    }

    public Long machineDetectionTime() {
        return this.machineDetectionTime;
    }

    public String machineDetectionUrl() {
        return this.machineDetectionUrl;
    }

    public String machineDetectionMethod() {
        return this.machineDetectionMethod;
    }

    public Map<String, String> sipHeaders() {
        return this.sipHeaders;
    }

    public Long ringTimeout() {
        return this.ringTimeout;
    }

    public String parentCallUuid() {
        return this.parentCallUuid;
    }

    public Boolean errorIfParentNotFound() {
        return this.errorIfParentNotFound;
    }

    public CallCreator answerMethod(String answerMethod) {
        this.answerMethod = answerMethod;
        return this;
    }

    public CallCreator ringUrl(String ringUrl) {
        this.ringUrl = ringUrl;
        return this;
    }

    public CallCreator ringMethod(String ringMethod) {
        this.ringMethod = ringMethod;
        return this;
    }

    public CallCreator hangupUrl(String hangupUrl) {
        this.hangupUrl = hangupUrl;
        return this;
    }

    public CallCreator hangupMethod(String hangupMethod) {
        this.hangupMethod = hangupMethod;
        return this;
    }

    public CallCreator fallbackUrl(String fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public CallCreator fallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
        return this;
    }

    public CallCreator callbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CallCreator callbackMethod(String callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public CallCreator callerName(String callerName) {
        this.callerName = callerName;
        return this;
    }

    public CallCreator sendDigits(String sendDigits) {
        this.sendDigits = sendDigits;
        return this;
    }

    public CallCreator sendOnPreanswer(Boolean sendOnPreanswer) {
        this.sendOnPreanswer = sendOnPreanswer;
        return this;
    }

    public CallCreator timeLimit(Long timeLimit) {
        this.timeLimit = timeLimit;
        return this;
    }

    public CallCreator hangupOnRing(Long hangupOnRing) {
        this.hangupOnRing = hangupOnRing;
        return this;
    }

    public CallCreator machineDetection(String machineDetection) {
        this.machineDetection = machineDetection;
        return this;
    }

    public CallCreator machineDetectionTime(Long machineDetectionTime) {
        this.machineDetectionTime = machineDetectionTime;
        return this;
    }

    public CallCreator machineDetectionUrl(String machineDetectionUrl) {
        this.machineDetectionUrl = machineDetectionUrl;
        return this;
    }

    public CallCreator machineDetectionMethod(String machineDetectionMethod) {
        this.machineDetectionMethod = machineDetectionMethod;
        return this;
    }

    public CallCreator sipHeaders(Map<String, String> sipHeaders) {
        this.sipHeaders = sipHeaders;
        return this;
    }

    public CallCreator ringTimeout(Long ringTimeout) {
        this.ringTimeout = ringTimeout;
        return this;
    }

    public CallCreator parentCallUuid(String parentCallUuid) {
        this.parentCallUuid = parentCallUuid;
        return this;
    }

    public CallCreator errorIfParentNotFound(Boolean errorIfParentNotFound) {
        this.errorIfParentNotFound = errorIfParentNotFound;
        return this;
    }

    @Override
    protected Call<CallCreateResponse> obtainCall() {
        return this.client().getApiService().callCreate(this.client().getAuthId(), this);
    }
}

