/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.examples;

import com.plivo.api.exceptions.PlivoXmlException;
import com.plivo.api.xml.Response;
import com.plivo.api.xml.Speak;

public class SSML {
    public static void main(String[] args) throws Exception {
        SSML.validateSSMLInvalidLanguage();
    }

    public static void validateEmptyVoiceWithSSML() {
        try {
            Response response = new Response().children(new Speak("validate speak", "", "US English", 0).addBreak("maximum", "250ms"));
            System.out.println(response.toXmlString());
        }
        catch (PlivoXmlException e) {
            e.printStackTrace();
        }
    }

    public static void validateManOrWomenVoiceWithSSML() {
        try {
            Response response = new Response().children(new Speak("validate speak", "MAN", "US English", 0).addBreak("maximum", "250ms"));
            System.out.println(response.toXmlString());
        }
        catch (PlivoXmlException e) {
            e.printStackTrace();
        }
    }

    public static void validateSpeakWithDefaultManOrWomenVoiceWithoutSSML() {
        try {
            Response response = new Response().children(new Speak("validate speak", "MAN", "US English", 0));
            System.out.println(response.toXmlString());
        }
        catch (PlivoXmlException e) {
            e.printStackTrace();
        }
    }

    public static void validateSpeakCharlimit() {
        try {
            Response response = new Response().children(new Speak(SSML.getAlphaNumericString(3330), "MAN", "US English", 0));
            System.out.println(response.toXmlString());
        }
        catch (PlivoXmlException e) {
            e.printStackTrace();
        }
    }

    public static void validateBasicSSML() {
        try {
            Response response = new Response().children(new Speak("validate speak", "Polly.Salli", "US English", 0).addBreak("maximum", "250ms").continueSpeak("Continue speak test 1.").addEmphasis("sdfghjjhd", "maximum").addLang("LANG LANG", "maximum").continueSpeak("THIS IS A TEST."));
            System.out.println(response.toXmlString());
        }
        catch (PlivoXmlException e) {
            e.printStackTrace();
        }
    }

    public static void validateSSMLVoiceLength() {
        try {
            Response response = new Response().children(new Speak("validate speak", "Polly.", "US English", 0).addBreak("maximum", "250ms").continueSpeak("Continue speak test 1.").addEmphasis("sdfghjjhd", "maximum").addLang("LANG LANG", "maximum").continueSpeak("THIS IS A TEST."));
            System.out.println(response.toXmlString());
        }
        catch (PlivoXmlException e) {
            e.printStackTrace();
        }
    }

    public static void validateSSMLInvalidLanguage() {
        try {
            Response response = new Response().children(new Speak("validate speak", "Polly.", "US Englis", 0).addBreak("maximum", "250ms").continueSpeak("Continue speak test 1.").addEmphasis("sdfghjjhd", "maximum").addLang("LANG LANG", "maximum").continueSpeak("THIS IS A TEST."));
            System.out.println(response.toXmlString());
        }
        catch (PlivoXmlException e) {
            e.printStackTrace();
        }
    }

    public static String getAlphaNumericString(int n) {
        String AlphaNumericString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvxyz";
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            int index = (int)((double)AlphaNumericString.length() * Math.random());
            sb.append(AlphaNumericString.charAt(index));
        }
        return sb.toString();
    }
}

