/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.base;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.IterableError;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.models.base.BaseRequest;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.base.ListResponse;
import com.plivo.api.util.Utils;
import java.io.IOException;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import retrofit2.Call;
import retrofit2.Response;

@JsonSerialize(typing=JsonSerialize.Typing.STATIC)
public abstract class MessagingBrandLister<T extends BaseResource>
extends BaseRequest<T>
implements Iterable<T> {
    protected Integer limit = null;
    protected Integer offset = null;

    @Override
    public MessagingBrandLister<T> client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    public Integer limit() {
        return this.limit;
    }

    public Integer offset() {
        return this.offset;
    }

    public MessagingBrandLister<T> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public MessagingBrandLister<T> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    protected abstract Call<ListResponse<T>> obtainCall() throws PlivoValidationException;

    public ListResponse<T> list() throws IOException, PlivoRestException, PlivoValidationException {
        this.validate();
        Response response = this.obtainCall().execute();
        this.handleResponse(response);
        return (ListResponse)response.body();
    }

    protected Map<String, Object> toMap() {
        this.client();
        MessagingBrandLister messagingBrandLister = this;
        return Utils.objectToMap(messagingBrandLister.plivoClient.getObjectMapper(), this);
    }

    @Override
    public Iterator<T> iterator() throws IterableError {
        if (this.limit == null) {
            this.limit = 20;
        }
        if (this.offset == null) {
            this.offset = 0;
        }
        return new Iterator<T>(){
            Deque<T> items = new ConcurrentLinkedDeque();

            @Override
            public boolean hasNext() {
                if (!this.items.isEmpty()) {
                    return true;
                }
                try {
                    ListResponse itemList = MessagingBrandLister.this.list();
                    if (itemList.getBrands().isEmpty()) {
                        return false;
                    }
                    this.items.addAll(itemList.getBrands());
                    MessagingBrandLister.this.offset = MessagingBrandLister.this.offset + MessagingBrandLister.this.limit;
                }
                catch (PlivoRestException | PlivoValidationException | IOException exception) {
                    throw new IterableError();
                }
                return true;
            }

            @Override
            public T next() {
                if (this.items.isEmpty()) {
                    try {
                        ListResponse itemList = MessagingBrandLister.this.list();
                        this.items.addAll(itemList.getBrands());
                        MessagingBrandLister.this.offset = MessagingBrandLister.this.offset + MessagingBrandLister.this.limit;
                    }
                    catch (PlivoRestException | PlivoValidationException | IOException exception) {
                        throw new IterableError();
                    }
                }
                return (BaseResource)this.items.removeFirst();
            }
        };
    }
}

