/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.brand;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.brand.Address;
import com.plivo.api.models.brand.AuthorizedContact;
import com.plivo.api.models.brand.BrandCreator;
import com.plivo.api.models.brand.BrandDeleter;
import com.plivo.api.models.brand.BrandGetter;
import com.plivo.api.models.brand.BrandLister;
import com.plivo.api.models.brand.BrandResponse;
import com.plivo.api.models.brand.BrandUseCaseGetter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Brand
extends BaseResource {
    private String brandID;
    private String brandAlias;
    private String brandType;
    private String einIssuingCountry;
    private String entityType;
    private String profileUUID;
    private String registrationStatus;
    private String vertical;
    private Address address;
    private AuthorizedContact authorizedContact;
    private BrandResponse brand;
    private String createdAt;

    public static BrandCreator creator(String brandAlias, String profileUUID, String brandType, Boolean secondaryVetting, String url, String method) {
        return new BrandCreator(brandAlias, profileUUID, brandType, secondaryVetting, url, method);
    }

    public static BrandGetter getter(String id) {
        return new BrandGetter(id);
    }

    public static BrandLister lister() {
        return new BrandLister();
    }

    public static BrandUseCaseGetter get_usecases(String id) {
        return new BrandUseCaseGetter(id);
    }

    public static BrandDeleter deleter(String id) {
        return new BrandDeleter(id);
    }

    public String getBrandAlias() {
        return this.brandAlias;
    }

    public String getBrandID() {
        return this.brandID;
    }

    public String getBrandType() {
        return this.brandType;
    }

    public String getEinIssuingCountry() {
        return this.einIssuingCountry;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getProfileUUID() {
        return this.profileUUID;
    }

    public String getRegistrationStatus() {
        return this.registrationStatus;
    }

    public String getVertical() {
        return this.vertical;
    }

    public Address getAddress() {
        return this.address;
    }

    public AuthorizedContact getAuthorizedContact() {
        return this.authorizedContact;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public BrandResponse getBrand() {
        return this.brand;
    }

    @Override
    public String getId() {
        return this.brandID;
    }
}

