/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.call.actions;

import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.models.base.VoiceCreator;
import com.plivo.api.models.call.actions.CallStreamCreateResponse;
import java.io.IOException;
import retrofit2.Call;

public class CallStreamCreator
extends VoiceCreator<CallStreamCreateResponse> {
    private final String id;
    private String serviceUrl;
    private Boolean bidirectional;
    private String audioTrack;
    private Integer streamTimeout;
    private String statusCallbackUrl;
    private String statusCallbackMethod;
    private String contentType;
    private String extraHeaders;

    public CallStreamCreator(String id, String serviceUrl) {
        this.id = id;
        this.serviceUrl = serviceUrl;
    }

    @Override
    protected Call<CallStreamCreateResponse> obtainCall() {
        return this.client().getVoiceApiService().callStreamCreate(this.client().getAuthId(), this.id, this);
    }

    @Override
    protected Call<CallStreamCreateResponse> obtainFallback1Call() {
        return this.client().getVoiceFallback1Service().callStreamCreate(this.client().getAuthId(), this.id, this);
    }

    @Override
    protected Call<CallStreamCreateResponse> obtainFallback2Call() {
        return this.client().getVoiceFallback2Service().callStreamCreate(this.client().getAuthId(), this.id, this);
    }

    public CallStreamCreateResponse stream() throws IOException, PlivoRestException {
        return (CallStreamCreateResponse)this.create();
    }

    @Override
    public CallStreamCreator client(PlivoClient plivoClient) {
        this.plivoClient = plivoClient;
        return this;
    }

    public CallStreamCreator serviceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public CallStreamCreator bidirectional(Boolean bidirectional) {
        this.bidirectional = bidirectional;
        return this;
    }

    public CallStreamCreator audioTrack(String audioTrack) {
        this.audioTrack = audioTrack;
        return this;
    }

    public CallStreamCreator streamTimeout(Integer streamTimeout) {
        this.streamTimeout = streamTimeout;
        return this;
    }

    public CallStreamCreator statusCallbackUrl(String statusCallbackUrl) {
        this.statusCallbackUrl = statusCallbackUrl;
        return this;
    }

    public CallStreamCreator statusCallbackMethod(String statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
        return this;
    }

    public CallStreamCreator contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public CallStreamCreator extraHeaders(String extraHeaders) {
        this.extraHeaders = extraHeaders;
        return this;
    }

    public String serviceUrl() {
        return this.serviceUrl;
    }

    public Boolean bidirectional() {
        return this.bidirectional;
    }

    public String audioTrack() {
        return this.audioTrack;
    }

    public Integer streamTimeout() {
        return this.streamTimeout;
    }

    public String statusCallbackUrl() {
        return this.statusCallbackUrl;
    }

    public String statusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public String contentType() {
        return this.contentType;
    }

    public String extraHeaders() {
        return this.extraHeaders;
    }
}

