/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.endpoint;

import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.endpoint.EndpointCreator;
import com.plivo.api.models.endpoint.EndpointDeleter;
import com.plivo.api.models.endpoint.EndpointGetter;
import com.plivo.api.models.endpoint.EndpointLister;
import com.plivo.api.models.endpoint.EndpointUpdater;
import com.plivo.api.util.Utils;

public class Endpoint
extends BaseResource {
    private String alias;
    private String application;
    private String endpointId;
    private String resourceUri;
    private String sipExpires;
    private String sipRegistered;
    private String sipUri;
    private String sipContact;
    private String sipUserAgent;
    private String subAccount;
    private String username;
    private String password;

    public static EndpointCreator creator(String username, String password, String alias) {
        if (!Utils.allNotNull(username, password, alias)) {
            throw new IllegalArgumentException("username, password and alias cannot be null");
        }
        return new EndpointCreator(username, password, alias);
    }

    public static EndpointLister lister() {
        return new EndpointLister();
    }

    public static EndpointGetter getter(String id) {
        return new EndpointGetter(id);
    }

    public static EndpointUpdater updater(String id) {
        return new EndpointUpdater(id);
    }

    public static EndpointDeleter deleter(String id) {
        return new EndpointDeleter(id);
    }

    public String getSipContact() {
        return this.sipContact;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getApplication() {
        return this.application;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public String getSipExpires() {
        return this.sipExpires;
    }

    public String getSipRegistered() {
        return this.sipRegistered;
    }

    public String getSipUri() {
        return this.sipUri;
    }

    public String getSipUserAgent() {
        return this.sipUserAgent;
    }

    public String getSubAccount() {
        return this.subAccount;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public EndpointUpdater updater() {
        return Endpoint.updater(this.endpointId);
    }

    public EndpointDeleter deleter() {
        return Endpoint.deleter(this.endpointId);
    }

    @Override
    public String getId() {
        return this.getEndpointId();
    }
}

