/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.profile;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.profile.ProfileAdder;
import com.plivo.api.models.profile.ProfileAddress;
import com.plivo.api.models.profile.ProfileAuthorizedContact;
import com.plivo.api.models.profile.ProfileDeleter;
import com.plivo.api.models.profile.ProfileGetter;
import com.plivo.api.models.profile.ProfileLister;
import com.plivo.api.models.profile.ProfileResponse;
import com.plivo.api.models.profile.ProfileUpdater;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Profile
extends BaseResource {
    private String profileAlias;
    private String customerType;
    private String entityType;
    private String companyName;
    private String ein;
    private String einIssuingCountry;
    private ProfileAddress address;
    private String stockSymbol;
    private String stockExchange;
    private String website;
    private String vertical;
    private String altBusinessIdType;
    private String plivoSubaccount;
    private ProfileAuthorizedContact authorizedContact;
    private String primaryProfile;
    private String profileType;
    private String profileUUID;
    private String message;
    private String createdAt;
    private ProfileResponse profile;

    public static ProfileAdder creator(String profileAlias, String customerType, String entityType, String companyName, String ein, String einIssuingCountry, ProfileAddress address, String stockSymbol, String stockExchange, String website, String vertical, String altBusinessID, String altBusinessIdType, String plivoSubaccount, ProfileAuthorizedContact authorizedContact) {
        return new ProfileAdder(profileAlias, customerType, entityType, companyName, ein, einIssuingCountry, address, stockSymbol, stockExchange, website, vertical, altBusinessID, altBusinessIdType, plivoSubaccount, authorizedContact);
    }

    public static ProfileGetter getter(String id) {
        return new ProfileGetter(id);
    }

    public static ProfileLister lister() {
        return new ProfileLister();
    }

    public static ProfileUpdater update(String profileUUID) {
        return new ProfileUpdater(profileUUID);
    }

    public static ProfileDeleter delete(String profileUUID) {
        return new ProfileDeleter(profileUUID);
    }

    public String getProfileUUID() {
        return this.profileUUID;
    }

    public String getProfileAlias() {
        return this.profileAlias;
    }

    public String getCustomerType() {
        return this.customerType;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getEin() {
        return this.ein;
    }

    public String getEinIssuingCountry() {
        return this.einIssuingCountry;
    }

    public ProfileAddress getAddress() {
        return this.address;
    }

    public String getStockSymbol() {
        return this.stockSymbol;
    }

    public String getStockExchange() {
        return this.stockExchange;
    }

    public String getwebsite() {
        return this.website;
    }

    public String getVertical() {
        return this.vertical;
    }

    public String getAltBusinessIdType() {
        return this.altBusinessIdType;
    }

    public String getPlivoSubaccount() {
        return this.plivoSubaccount;
    }

    public ProfileAuthorizedContact getAuthorizedContact() {
        return this.authorizedContact;
    }

    public String getPrimaryProfile() {
        return this.primaryProfile;
    }

    public String getProfileType() {
        return this.profileType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public ProfileResponse getProfile() {
        return this.profile;
    }

    @Override
    public String getId() {
        return this.profileUUID;
    }
}

