/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plivo.api.exceptions.PlivoXmlException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Utils {
    private static final Pattern timePattern = Pattern.compile("^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}(:\\d{2}(\\.\\d{1,6})?)?$");
    private static final String SIGNATURE_ALGORITHM = "HmacSHA256";

    public static boolean allNotNull(Object ... objects) {
        return Stream.of(objects).noneMatch(Objects::isNull);
    }

    public static boolean isSubaccountIdValid(String id) {
        return id != null && id.startsWith("SA") && id.length() == 20;
    }

    public static boolean isAccountIdValid(String id) {
        return id != null && id.startsWith("MA") && id.length() == 20;
    }

    public static boolean anyNotNull(Object ... objects) {
        return Stream.of(objects).anyMatch(Objects::nonNull);
    }

    public static boolean isValidTimeString(String time) {
        return timePattern.matcher(time).matches();
    }

    public static boolean isNonEmptyString(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public static Map<String, Object> objectToMap(ObjectMapper objectMapper, Object object) {
        Map origMap = (Map)objectMapper.convertValue(object, Map.class);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : origMap.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof Map) {
                Map innerEntries = (Map)objectMapper.convertValue(entry.getValue(), Map.class);
                for (Map.Entry innerEntry : innerEntries.entrySet()) {
                    map.put((String)entry.getKey() + (String)innerEntry.getKey(), innerEntry.getValue());
                }
                continue;
            }
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static String computeSignature(String url, String nonce, String authToken) throws NoSuchAlgorithmException, InvalidKeyException, MalformedURLException, UnsupportedEncodingException {
        if (!Utils.allNotNull(url, nonce, authToken)) {
            throw new IllegalArgumentException("url, nonce and authToken must be non-null");
        }
        URL parsedURL = new URL(url);
        String baseUrl = parsedURL.getProtocol() + "://" + parsedURL.getHost();
        if (parsedURL.getPort() != -1) {
            baseUrl = baseUrl + ":" + Integer.toString(parsedURL.getPort());
        }
        baseUrl = baseUrl + parsedURL.getPath();
        String payload = baseUrl + nonce;
        SecretKeySpec signingKey = new SecretKeySpec(authToken.getBytes("UTF-8"), SIGNATURE_ALGORITHM);
        Mac mac = Mac.getInstance(SIGNATURE_ALGORITHM);
        mac.init(signingKey);
        return new String(Base64.getEncoder().encode(mac.doFinal(payload.getBytes("UTF-8"))));
    }

    public static boolean validateSignature(String url, String nonce, String signature, String authToken) throws NoSuchAlgorithmException, InvalidKeyException, MalformedURLException, UnsupportedEncodingException {
        return Utils.computeSignature(url, nonce, authToken).equals(signature);
    }

    public static String generateUrl(String url, String method, Map<String, String> params) throws MalformedURLException, UnsupportedEncodingException {
        String decodedUrl = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        URL parsedURL = new URL(decodedUrl);
        String paramString = "";
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        String uri = parsedURL.getProtocol() + "://" + parsedURL.getHost() + parsedURL.getPath();
        int queryParamLength = 0;
        try {
            queryParamLength = parsedURL.getQuery().length();
            if (params.size() > 0 || queryParamLength > 0) {
                uri = uri + "?";
            }
        }
        catch (Exception e) {
            queryParamLength = 0;
            uri = uri + "?";
        }
        if (queryParamLength > 0) {
            if (method == "GET") {
                Map<String, String> queryParamMap = Utils.getMapFromQueryString(parsedURL.getQuery());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    queryParamMap.put(entry.getKey(), entry.getValue());
                }
                uri = uri + Utils.GetSortedQueryParamString(queryParamMap, true);
            } else {
                uri = uri + Utils.GetSortedQueryParamString(Utils.getMapFromQueryString(parsedURL.getQuery()), true) + "." + Utils.GetSortedQueryParamString(params, false);
                uri = uri.replace(".$", "");
            }
        } else {
            uri = method == "GET" ? uri + Utils.GetSortedQueryParamString(params, true) : uri + Utils.GetSortedQueryParamString(params, false);
        }
        return uri;
    }

    public static Map<String, String> getMapFromQueryString(String query) {
        Map<String, String> params = null;
        if (query.length() == 0) {
            return params;
        }
        params = Arrays.stream(query.split("&")).map(s -> s.split("=", 2)).collect(Collectors.toMap(a -> a[0], a -> ((String[])a).length > 1 ? a[1] : ""));
        return params;
    }

    public static String GetSortedQueryParamString(Map<String, String> params, boolean queryParams) {
        String url = "";
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        if (queryParams) {
            for (String key : keys) {
                url = url + key + "=" + params.get(key) + "&";
            }
            url = url.substring(0, url.length() - 1);
        } else {
            for (String key : keys) {
                url = url + key + params.get(key);
            }
        }
        return url;
    }

    public static String computeSignatureV3(String url, String nonce, String authToken, String method, Map<String, String> params) throws NoSuchAlgorithmException, InvalidKeyException, MalformedURLException, UnsupportedEncodingException {
        if (!Utils.allNotNull(url, nonce, authToken)) {
            throw new IllegalArgumentException("url, nonce and authToken must be non-null");
        }
        URL parsedURL = new URL(url);
        String payload = Utils.generateUrl(url, method, params) + "." + nonce;
        SecretKeySpec signingKey = new SecretKeySpec(authToken.getBytes("UTF-8"), SIGNATURE_ALGORITHM);
        Mac mac = Mac.getInstance(SIGNATURE_ALGORITHM);
        mac.init(signingKey);
        return new String(Base64.getEncoder().encode(mac.doFinal(payload.getBytes("UTF-8"))));
    }

    public static boolean validateSignatureV3(String url, String nonce, String signature, String authToken, String method, Map<String, String> ... params) throws NoSuchAlgorithmException, InvalidKeyException, MalformedURLException, UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap();
        if (params.length > 0) {
            parameters = params[0];
        }
        List<String> splitSignature = Arrays.asList(signature.split(","));
        return splitSignature.contains(Utils.computeSignatureV3(url, nonce, authToken, method, parameters));
    }

    private static Map<String, List<String>> getLanguageVoices() {
        HashMap<String, List<String>> languageVoices = new HashMap<String, List<String>>();
        languageVoices.put("arb", new ArrayList<String>(Arrays.asList("Zeina")));
        languageVoices.put("cmn-CN", new ArrayList<String>(Arrays.asList("Zhiyu")));
        languageVoices.put("da-DK", new ArrayList<String>(Arrays.asList("Naja", "Mads")));
        languageVoices.put("nl-NL", new ArrayList<String>(Arrays.asList("Lotte", "Ruben")));
        languageVoices.put("en-AU", new ArrayList<String>(Arrays.asList("Nicole", "Russell")));
        languageVoices.put("en-GB", new ArrayList<String>(Arrays.asList("Amy", "Emma", "Brian")));
        languageVoices.put("en-IN", new ArrayList<String>(Arrays.asList("Raveena", "Aditi")));
        languageVoices.put("en-US", new ArrayList<String>(Arrays.asList("Joanna", "Salli", "Kendra", "Kimberly", "Ivy", "Matthew", "Justin", "Joey")));
        languageVoices.put("en-GB-WLS", new ArrayList<String>(Arrays.asList("Geraint")));
        languageVoices.put("fr-CA", new ArrayList<String>(Arrays.asList("Chantal", "Chantal")));
        languageVoices.put("fr-FR", new ArrayList<String>(Arrays.asList("L\u00e9a", "C\u00e9line", "Mathieu")));
        languageVoices.put("de-DE", new ArrayList<String>(Arrays.asList("Vicki", "Hans")));
        languageVoices.put("hi-IN", new ArrayList<String>(Arrays.asList("Aditi")));
        languageVoices.put("is-IS", new ArrayList<String>(Arrays.asList("D\u00f3ra", "Karl")));
        languageVoices.put("it-IT", new ArrayList<String>(Arrays.asList("Carla", "Giorgio")));
        languageVoices.put("ja-JP", new ArrayList<String>(Arrays.asList("Mizuki", "Takumi")));
        languageVoices.put("ko-KR", new ArrayList<String>(Arrays.asList("Seoyeon")));
        languageVoices.put("nb-NO", new ArrayList<String>(Arrays.asList("Liv")));
        languageVoices.put("pl-PL", new ArrayList<String>(Arrays.asList("Ewa", "Maja", "Jacek", "Jan")));
        languageVoices.put("pt-BR", new ArrayList<String>(Arrays.asList("Vit\u00f3ria", "Ricardo")));
        languageVoices.put("pt-PT", new ArrayList<String>(Arrays.asList("In\u00eas", "Cristiano")));
        languageVoices.put("ro-RO", new ArrayList<String>(Arrays.asList("Carmen")));
        languageVoices.put("ru-RU", new ArrayList<String>(Arrays.asList("Tatyana", "Maxim")));
        languageVoices.put("es-ES", new ArrayList<String>(Arrays.asList("Conchita", "Lucia", "Enrique")));
        languageVoices.put("es-MX", new ArrayList<String>(Arrays.asList("Mia")));
        languageVoices.put("es-US", new ArrayList<String>(Arrays.asList("Pen\u00e9lope", "Miguel")));
        languageVoices.put("sv-SE", new ArrayList<String>(Arrays.asList("Astrid")));
        languageVoices.put("tr-TR", new ArrayList<String>(Arrays.asList("Filiz")));
        languageVoices.put("cy-GB", new ArrayList<String>(Arrays.asList("Gwyneth")));
        return languageVoices;
    }

    public static void validateLanguageVoice(String language, String voice) throws PlivoXmlException {
        String[] voiceParts = voice.split("\\.");
        System.out.println(language);
        if (voiceParts.length != 2 || !voiceParts[0].equals("Polly")) {
            throw new PlivoXmlException("XML Validation Error: Invalid language. Voice " + voice + " is not valid. Refer <https://www.plivo.com/docs/voice/getting-started/advanced/getting-started-with-ssml/#ssml-voices> for the list of supported voices.");
        }
        Map<String, List<String>> languageVoices = Utils.getLanguageVoices();
        if (languageVoices.get(language) == null || languageVoices.get(language).isEmpty()) {
            throw new PlivoXmlException("XML Validation Error: Invalid language. Language " + language + " is not supported.");
        }
        List<String> availableLanguageVoices = languageVoices.get(language);
        for (int i = 0; i < availableLanguageVoices.size(); ++i) {
            availableLanguageVoices.set(i, Utils.transformString(availableLanguageVoices.get(i)));
        }
        String transformedVoiceName = Utils.transformString(voiceParts[1]);
        if (!voiceParts[1].equals("*") && !availableLanguageVoices.contains(transformedVoiceName)) {
            throw new PlivoXmlException("XML Validation Error: <Speak> voice '" + voice + "' is not valid. Refer <https://www.plivo.com/docs/voice/getting-started/advanced/getting-started-with-ssml/#ssml-voices> for list of supported voices.");
        }
    }

    public static String transformString(String s) {
        String transformedString = Normalizer.normalize(s.trim(), Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        transformedString = pattern.matcher(transformedString).replaceAll("");
        transformedString = new ArrayList<String>(Arrays.asList(transformedString.toLowerCase().split(" "))).stream().map(word -> Character.toTitleCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining("_"));
        return transformedString;
    }
}

