/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.xml;

import com.plivo.api.exceptions.PlivoXmlException;
import com.plivo.api.util.Utils;
import com.plivo.api.xml.Break;
import com.plivo.api.xml.Emphasis;
import com.plivo.api.xml.GetDigitsNestable;
import com.plivo.api.xml.GetInputNestable;
import com.plivo.api.xml.Lang;
import com.plivo.api.xml.P;
import com.plivo.api.xml.Phoneme;
import com.plivo.api.xml.PlivoXml;
import com.plivo.api.xml.PreAnswerNestable;
import com.plivo.api.xml.Prosody;
import com.plivo.api.xml.ResponseNestable;
import com.plivo.api.xml.S;
import com.plivo.api.xml.SayAs;
import com.plivo.api.xml.SpeakNestable;
import com.plivo.api.xml.Sub;
import com.plivo.api.xml.W;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement(name="Speak")
@XmlSeeAlso(value={Lang.class, Emphasis.class, Break.class, SayAs.class, Sub.class, S.class, W.class, P.class, Phoneme.class, Prosody.class})
public class Speak
extends PlivoXml
implements ResponseNestable,
PreAnswerNestable,
GetDigitsNestable,
GetInputNestable {
    @XmlMixed
    private List<Object> mixedContent = new ArrayList<Object>();
    @XmlAttribute
    private String voice;
    @XmlAttribute
    private String language;
    @XmlAttribute
    private Integer loop;
    private static boolean isLang = false;
    private static boolean isVoice = false;
    private static int MAX_CONTENT_LENGTH = 3000;

    private Speak() {
    }

    public Speak(String content) {
        this.mixedContent.add(content);
        this.voice = "WOMAN";
        this.language = "en-US";
        this.loop = 1;
    }

    public String getVoice() {
        return this.voice;
    }

    public String getLanguage() {
        return this.language;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public Speak voice(String voice) throws PlivoXmlException {
        this.voice = voice;
        isVoice = true;
        if (voice == null || voice.trim().isEmpty()) {
            this.voice = "WOMAN";
            return this;
        }
        if (voice.equalsIgnoreCase("MAN") || voice.equalsIgnoreCase("WOMAN")) {
            return this;
        }
        this.voice = Speak.transformVoiceString(voice);
        if (isLang) {
            Utils.validateLanguageVoice(this.language, this.voice);
        }
        return this;
    }

    public Speak language(String language) throws PlivoXmlException {
        this.language = language;
        isLang = true;
        if (isVoice) {
            if (this.voice.equalsIgnoreCase("MAN") || this.voice.equalsIgnoreCase("WOMAN")) {
                return this;
            }
            Utils.validateLanguageVoice(this.language, this.voice);
        }
        return this;
    }

    public Speak loop(Integer loop) {
        this.loop = loop;
        return this;
    }

    private void checkIsSSMLSupported() throws PlivoXmlException {
        if (this.voice == null || this.voice.trim().isEmpty() || this.voice.equalsIgnoreCase("MAN") || this.voice.equalsIgnoreCase("WOMAN")) {
            throw new PlivoXmlException("SSML support is available only for Amazon Polly!");
        }
    }

    private static String transformVoiceString(String voice) {
        String[] voiceParts = voice.trim().split("\\.");
        if (voiceParts.length == 1) {
            return voice;
        }
        String voiceName = Utils.transformString(voiceParts[1]);
        return voiceParts[0] + "." + voiceName;
    }

    public Speak addBreak(String strength, String time) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new Break(strength, time));
        return this;
    }

    public Speak addEmphasis(String content, String level) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new Emphasis(content, level));
        return this;
    }

    public Speak addLang(String content, String xmllang) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new Lang(content, xmllang));
        return this;
    }

    public Speak addP(String content) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new P(content));
        return this;
    }

    public Speak addPhoneme(String content, String alphabet, String ph) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new Phoneme(content, alphabet, ph));
        return this;
    }

    public Speak addProsody(String content) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new Prosody(content));
        return this;
    }

    public Speak addProsody(String content, String volume, String rate, String pitch) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new Prosody(content, volume, rate, pitch));
        return this;
    }

    public Speak addS(String content) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new S(content));
        return this;
    }

    public Speak addSayAs(String content, String interpretAs) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new SayAs(content, interpretAs));
        return this;
    }

    public Speak addSayAs(String content, String interpretAs, String format) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new SayAs(content, interpretAs, format));
        return this;
    }

    public Speak addSub(String content, String alias) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new Sub(content, alias));
        return this;
    }

    public Speak addW(String content, String role) throws PlivoXmlException {
        this.checkIsSSMLSupported();
        this.mixedContent.add(new W(content, role));
        return this;
    }

    public Speak continueSpeak(String content) throws PlivoXmlException {
        this.mixedContent.add(content);
        return this;
    }

    public Speak children(Object ... nestables) throws PlivoXmlException {
        for (Object obj : nestables) {
            if (!(obj instanceof SpeakNestable) && !(obj instanceof String)) {
                throw new PlivoXmlException("XML Validation Error: <" + obj.getClass().getSimpleName() + "> can not be nested in <Speak>");
            }
            this.mixedContent.add(obj);
        }
        return this;
    }
}

