/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.crypto;

import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.util.List;
import java.util.stream.Collectors;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.FixedPointUtil;

public class BitcoinAddress {
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    public static final ECDomainParameters CURVE;

    public static String p2wpkhAddress(NetworkParameters params, ECPublicKey ecPublicKey) {
        return Address.fromKey((NetworkParameters)params, (ECKey)BitcoinAddress.toEcKey(ecPublicKey), (Script.ScriptType)Script.ScriptType.P2WPKH).toString();
    }

    public static String p2shAddress(NetworkParameters params, int threshold, List<ECPublicKey> ecPublicKeys) {
        List keys = ecPublicKeys.stream().map(ecPublicKey -> BitcoinAddress.toEcKey(ecPublicKey)).collect(Collectors.toList());
        Script redeemScript = ScriptBuilder.createRedeemScript((int)threshold, keys);
        Script script = ScriptBuilder.createP2SHOutputScript((Script)redeemScript);
        Address multisig = script.getToAddress(params);
        return multisig.toString();
    }

    private static ECKey toEcKey(ECPublicKey ecPublicKey) {
        ECPoint point = ecPublicKey.getW();
        return ECKey.fromPublicOnly((org.bouncycastle.math.ec.ECPoint)CURVE.getCurve().createPoint(point.getAffineX(), point.getAffineY()), (boolean)true);
    }

    static {
        FixedPointUtil.precompute((org.bouncycastle.math.ec.ECPoint)CURVE_PARAMS.getG());
        CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    }
}

