/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.gen.OctetKeyPairGenerator;
import com.nimbusds.jose.util.Base64URL;
import com.plooh.adssi.dial.crypto.CommonCurveKeyService;
import io.ipfs.multibase.Multibase;
import java.util.ArrayList;
import java.util.List;

public class Common25519Service
extends CommonCurveKeyService {
    private final Curve curve;
    private final KeyUse keyUse;

    public Common25519Service(Curve curve, KeyUse keyUse) {
        this.curve = curve;
        this.keyUse = keyUse;
    }

    public OctetKeyPair genKeyPair(String keyID) {
        try {
            return (OctetKeyPair)new OctetKeyPairGenerator(this.curve).keyID(keyID).generate();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String publicKeyMultibase(JWK publicJWK, Multibase.Base base) {
        OctetKeyPair okp = (OctetKeyPair)publicJWK;
        byte[] pkBytes = okp.getX().decode();
        return Multibase.encode((Multibase.Base)base, (byte[])pkBytes);
    }

    @Override
    public JWK publicKeyFromMultibase(String publicKeyMultibase, String keyID) {
        byte[] keyBytes = Multibase.decode((String)publicKeyMultibase);
        Base64URL x = Base64URL.encode((byte[])keyBytes);
        return new OctetKeyPair.Builder(this.curve, x).keyID(keyID).keyUse(this.keyUse).build();
    }

    public List<OctetKeyPair> keyPairs(int qty, int startIndex, String did, String prefix) {
        ArrayList<OctetKeyPair> result = new ArrayList<OctetKeyPair>();
        for (int i = 0; i < qty; ++i) {
            result.add(this.genKeyPair(did + prefix + (i + startIndex)));
        }
        return result;
    }
}

