/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jose.util.Base64URL;
import com.plooh.adssi.dial.crypto.CommonCurveKeyService;
import io.ipfs.multibase.Multibase;
import java.util.ArrayList;
import java.util.List;

public class CommonECKeyService
extends CommonCurveKeyService {
    private final Curve curve;
    private final KeyUse keyUse;

    public CommonECKeyService(Curve curve, KeyUse keyUse) {
        this.curve = curve;
        this.keyUse = keyUse;
    }

    public ECKey genKeyPair(String keyID) {
        try {
            return (ECKey)new ECKeyGenerator(this.curve).keyUse(this.keyUse).keyID(keyID).generate();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String publicKeyMultibase(JWK publicJWK, Multibase.Base base) {
        ECKey ecKey = (ECKey)publicJWK;
        byte[] xBytes = ecKey.getX().decode();
        byte[] yBytes = ecKey.getY().decode();
        byte[] c = new byte[xBytes.length + yBytes.length];
        System.arraycopy(xBytes, 0, c, 0, xBytes.length);
        System.arraycopy(yBytes, 0, c, xBytes.length, yBytes.length);
        return Multibase.encode((Multibase.Base)base, (byte[])c);
    }

    @Override
    public JWK publicKeyFromMultibase(String publicKeyMultibase, String keyID) {
        byte[] keyBytes = Multibase.decode((String)publicKeyMultibase);
        byte[] xBytes = new byte[keyBytes.length / 2];
        byte[] yBytes = new byte[keyBytes.length / 2];
        System.arraycopy(keyBytes, 0, xBytes, 0, keyBytes.length / 2);
        System.arraycopy(keyBytes, keyBytes.length / 2, yBytes, 0, keyBytes.length / 2);
        Base64URL x = Base64URL.encode((byte[])xBytes);
        Base64URL y = Base64URL.encode((byte[])yBytes);
        return new ECKey.Builder(this.curve, x, y).keyID(keyID).keyUse(this.keyUse).build();
    }

    public List<ECKey> keyPairs(int qty, int startIndex, String did, String prefix) {
        ArrayList<ECKey> result = new ArrayList<ECKey>();
        for (int i = 0; i < qty; ++i) {
            result.add(this.genKeyPair(did + prefix + (i + startIndex)));
        }
        return result;
    }
}

