/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.crypto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import com.plooh.adssi.dial.data.Proof;
import com.plooh.adssi.dial.jcs.JCS;
import com.plooh.adssi.dial.json.JSON;
import com.plooh.adssi.dial.parser.SignedDocumentMapped;
import com.plooh.adssi.dial.parser.TimeFormat;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.UUID;

public abstract class JcsBase64EcSignature2021Service {
    public abstract String signatureType();

    protected abstract JWSSigner jwsSigner(JWK var1) throws JOSEException;

    protected abstract JWSVerifier jwsVerifier(JWK var1) throws JOSEException;

    protected abstract JWSAlgorithm jwsAlgorithm();

    public boolean verify(String recordJson, JWK publicJWK, Proof proof) {
        try {
            return this.verifyInternal(recordJson, publicJWK, proof);
        }
        catch (JsonProcessingException | JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    public String sign(String recordJson, JWK keyPair, Proof proof) {
        try {
            return this.signInternal(recordJson, keyPair, proof);
        }
        catch (JsonProcessingException | JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    private String signInternal(String recordJson, JWK keyPair, Proof proof) throws JOSEException, JsonProcessingException {
        if (proof.getCreated() == null) {
            proof.setCreated(TimeFormat.DTF.format(Instant.now()));
        }
        if ((proof.getAssertionMethod() == null || proof.getAssertionMethod().isEmpty()) && proof.getVerificationMethod() == null) {
            throw new IllegalStateException("Either assertion method or verification method must be set.");
        }
        if (proof.getIssuer() == null) {
            throw new IllegalStateException("Missing issuer");
        }
        proof.setType(this.signatureType());
        if (proof.getNonce() == null) {
            proof.setNonce(UUID.randomUUID().toString());
        }
        proof.setSignatureValue(null);
        String jwsHeaderJson = JSON.MAPPER.writeValueAsString((Object)proof);
        JWSHeader jwsHeader = new JWSHeader.Builder(this.jwsAlgorithm()).build();
        String signaturePayload = new SignedDocumentMapped(recordJson).deleteProof().toJson();
        Base64URL sign = this.jwsSigner(keyPair).sign(jwsHeader, this.signingInput(jwsHeaderJson, signaturePayload));
        proof.setSignatureValue(sign.toString());
        return new SignedDocumentMapped(recordJson).addProof(proof).toJson();
    }

    private boolean verifyInternal(String recordJson, JWK publicKey, Proof proof) throws JOSEException, JsonProcessingException {
        String signatureValue = proof.getSignatureValue();
        if (signatureValue == null) {
            throw new IllegalStateException("Missing signature value");
        }
        if (!this.signatureType().equals(proof.getType())) {
            throw new IllegalStateException("Wrong signature type");
        }
        proof.setSignatureValue(null);
        String jwsHeaderJson = JSON.MAPPER.writeValueAsString((Object)proof);
        JWSHeader jwsHeader = new JWSHeader.Builder(this.jwsAlgorithm()).build();
        String signaturePayload = new SignedDocumentMapped(recordJson).deleteProof().toJson();
        return this.jwsVerifier(publicKey).verify(jwsHeader, this.signingInput(jwsHeaderJson, signaturePayload), Base64URL.from((String)signatureValue));
    }

    private byte[] signingInput(String jwsHeaderJson, String datJson) {
        String jwsHeaderJCSBase64 = this.jcs_utf8_base64url(jwsHeaderJson).toString();
        String jwsPayloadString = this.jcs_utf8_base64url(datJson).toString();
        return (jwsHeaderJCSBase64 + "." + jwsPayloadString).getBytes(StandardCharsets.UTF_8);
    }

    private Base64URL jcs_utf8_base64url(String input) {
        return Base64URL.encode((String)JCS.encode(input));
    }
}

