/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.crypto;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.plooh.adssi.dial.crypto.CommonECKeyService;
import io.ipfs.multibase.Multibase;
import java.util.List;

public class Secp256k1VerificationKey2021Service {
    public static final String KEY_TYPE = "Secp256k1VerificationKey2021";
    private static final CommonECKeyService secp256k1 = new CommonECKeyService(Curve.SECP256K1, KeyUse.SIGNATURE);

    public static ECKey generateKeyPair(String keyID) {
        return secp256k1.genKeyPair(keyID);
    }

    public static String publicKeyMultibase(ECKey publicJWK) {
        return secp256k1.publicKeyMultibase((JWK)publicJWK, Multibase.Base.Base58BTC);
    }

    public static JWK publicKeyFromMultibase(String publicKeyMultibase, String keyID) {
        return secp256k1.publicKeyFromMultibase(publicKeyMultibase, keyID);
    }

    public static List<ECKey> keyPairs(int qty, String did) {
        return Secp256k1VerificationKey2021Service.keyPairs(qty, 0, did);
    }

    public static List<ECKey> keyPairs(int qty, int startIndex, String did) {
        return secp256k1.keyPairs(qty, startIndex, did, "#key-secp256k1-");
    }
}

