/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.examples.participant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.plooh.adssi.dial.crypto.BitcoinAddress;
import com.plooh.adssi.dial.crypto.CryptoService;
import com.plooh.adssi.dial.crypto.Ed25519VerificationKey2021Service;
import com.plooh.adssi.dial.crypto.Secp256k1VerificationKey2021Service;
import com.plooh.adssi.dial.data.AddressType;
import com.plooh.adssi.dial.data.Declaration;
import com.plooh.adssi.dial.data.Declarations;
import com.plooh.adssi.dial.data.ParticipantDeclaration;
import com.plooh.adssi.dial.data.Proof;
import com.plooh.adssi.dial.data.ProofPurpose;
import com.plooh.adssi.dial.data.SignatureAssertionMethod;
import com.plooh.adssi.dial.data.TreasuryAccount;
import com.plooh.adssi.dial.data.TreasuryAccountControler;
import com.plooh.adssi.dial.data.VerificationMethod;
import com.plooh.adssi.dial.examples.participant.NewParticipantDeclaration;
import com.plooh.adssi.dial.examples.participant.VerificationMethodData;
import com.plooh.adssi.dial.json.JSON;
import com.plooh.adssi.dial.parser.TimeFormat;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.MainNetParams;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CreateParticipantDeclaration {
    public NewParticipantDeclaration handle(Instant dateTime) throws JsonProcessingException, JOSEException, NoSuchAlgorithmException, NoSuchProviderException {
        String creationDate = TimeFormat.DTF.format(dateTime);
        Declarations declarations = new Declarations();
        declarations.setId(AddressType.uuid.normalize(UUID.randomUUID().toString()));
        declarations.setType("Declaration");
        declarations.setDeclaration(new ArrayList<Declaration>());
        ParticipantDeclaration participantDeclaration = new ParticipantDeclaration();
        declarations.getDeclaration().add(participantDeclaration);
        participantDeclaration.setCreated(creationDate);
        String participantId = AddressType.uuid.normalize(UUID.randomUUID().toString());
        participantDeclaration.setId(participantId);
        participantDeclaration.setController(Arrays.asList(participantId));
        participantDeclaration.setVerificationMethod(new ArrayList<VerificationMethod>());
        VerificationMethodData verif_ed25519 = this.verificationMethodEd25519(participantId, creationDate, 0);
        participantDeclaration.getVerificationMethod().add(verif_ed25519.getVerificationMethod());
        VerificationMethodData verif_secp2561 = this.verificationMethodSecp256k1(participantId, creationDate, 1);
        participantDeclaration.getVerificationMethod().add(verif_secp2561.getVerificationMethod());
        SignatureAssertionMethod signatureAssertionMethod = new SignatureAssertionMethod(participantId + "#" + creationDate + "#am-0");
        signatureAssertionMethod.setVerificationMethod(verif_ed25519.getId());
        participantDeclaration.setAssertionMethod(Arrays.asList(signatureAssertionMethod));
        TreasuryAccount treasuryAccount = new TreasuryAccount();
        String encodedPk = BitcoinAddress.p2wpkhAddress((NetworkParameters)MainNetParams.get(), verif_secp2561.getKeyPair().toECKey().toECPublicKey());
        treasuryAccount.setAddress(encodedPk);
        treasuryAccount.setNetwork(MainNetParams.get().getId());
        TreasuryAccountControler control = new TreasuryAccountControler();
        control.setQuorum(1);
        control.setVerificationMethod(Arrays.asList(verif_secp2561.getVerificationMethod().getId()));
        treasuryAccount.setControl(control);
        participantDeclaration.setAccount(Arrays.asList(treasuryAccount));
        Proof ed25519Proof = new Proof();
        ed25519Proof.setDocument(declarations.getId());
        ed25519Proof.setIssuer(participantId);
        ed25519Proof.setProofPurpose(ProofPurpose.PoP.name());
        ed25519Proof.setVerificationMethod(verif_ed25519.getVerificationMethod().getId());
        ed25519Proof.setCreated(creationDate);
        ed25519Proof.setNonce(UUID.randomUUID().toString());
        String signedRecord = CryptoService.ed25519SignatureService.sign(JSON.MAPPER.writeValueAsString((Object)declarations), verif_ed25519.getKeyPair(), ed25519Proof);
        Proof secp256k1Proof = new Proof();
        secp256k1Proof.setDocument(declarations.getId());
        secp256k1Proof.setIssuer(participantId);
        secp256k1Proof.setProofPurpose(ProofPurpose.PoP.name());
        secp256k1Proof.setVerificationMethod(verif_secp2561.getVerificationMethod().getId());
        secp256k1Proof.setCreated(creationDate);
        secp256k1Proof.setNonce(UUID.randomUUID().toString());
        signedRecord = CryptoService.secp256k1SignatureService.sign(signedRecord, verif_secp2561.getKeyPair(), secp256k1Proof);
        NewParticipantDeclaration result = new NewParticipantDeclaration();
        result.setRecord(signedRecord);
        result.getVerificationMethod().put(verif_ed25519.getId(), verif_ed25519);
        result.getVerificationMethod().put(verif_secp2561.getId(), verif_secp2561);
        return result;
    }

    public VerificationMethodData verificationMethodEd25519(String participantId, String creationDate, int index) {
        VerificationMethod verificationMethod = new VerificationMethod();
        verificationMethod.setId(participantId + "#" + creationDate + "#key-" + index);
        verificationMethod.setType("Ed25519VerificationKey2021");
        OctetKeyPair keyPair = Ed25519VerificationKey2021Service.generateKeyPair(verificationMethod.getId());
        String publicKeyMultibase = Ed25519VerificationKey2021Service.publicKeyMultibase(keyPair.toPublicJWK());
        verificationMethod.setPublicKeyMultibase(publicKeyMultibase);
        return new VerificationMethodData(verificationMethod.getId(), (JWK)keyPair, verificationMethod);
    }

    public VerificationMethodData verificationMethodSecp256k1(String participantId, String creationDate, int index) {
        VerificationMethod verificationMethod = new VerificationMethod();
        verificationMethod.setId(participantId + "#" + creationDate + "#key-" + index);
        verificationMethod.setType("Secp256k1VerificationKey2021");
        ECKey keyPair = Secp256k1VerificationKey2021Service.generateKeyPair(verificationMethod.getId());
        String publicKeyMultibase = Secp256k1VerificationKey2021Service.publicKeyMultibase(keyPair.toPublicJWK());
        verificationMethod.setPublicKeyMultibase(publicKeyMultibase);
        return new VerificationMethodData(verificationMethod.getId(), (JWK)keyPair, verificationMethod);
    }

    private static String adjustTo64(String s) {
        switch (s.length()) {
            case 62: {
                return "00" + s;
            }
            case 63: {
                return "0" + s;
            }
            case 64: {
                return s;
            }
        }
        throw new IllegalArgumentException("not a valid key: " + s);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

