/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.parser;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.plooh.adssi.dial.data.Proof;
import com.plooh.adssi.dial.json.JsonPathUtils;
import java.util.ArrayList;
import java.util.List;

public class SignedDocumentMapped {
    private static final String ROOT_PATH = "$";
    private static final String PROOF_PATH = "$.proof";
    private static final String PROOF_KEY = "proof";
    private static TypeRef<List<Proof>> proofList = new TypeRef<List<Proof>>(){};
    protected DocumentContext doc;

    public SignedDocumentMapped(String recordString) {
        this.doc = JsonPathUtils.parse(recordString);
    }

    public List<Proof> proof() {
        try {
            return (List)this.doc.read(PROOF_PATH, proofList);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public String id() {
        return (String)this.doc.read("$.id", String.class, new Predicate[0]);
    }

    public String type() {
        return (String)this.doc.read("$.type", String.class, new Predicate[0]);
    }

    public SignedDocumentMapped deleteProof() {
        this.doc.delete(PROOF_PATH, new Predicate[0]);
        return this;
    }

    public SignedDocumentMapped addProof(Proof proof) {
        List<Proof> list = this.proof();
        if (list == null) {
            this.doc = this.doc.put(ROOT_PATH, PROOF_KEY, new ArrayList(), new Predicate[0]);
        }
        this.doc = this.doc.add(PROOF_PATH, (Object)proof, new Predicate[0]);
        return this;
    }

    public String toJson() {
        return this.doc.jsonString();
    }
}

