/*
 * Decompiled with CFR 0.152.
 */
package com.plooh.adssi.dial.keystore;

import com.plooh.adssi.dial.keystore.ConfigSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class DialKeyStore {
    private KeyStore keyStore;
    private ConfigSource secretSource;
    private String storeAlias;

    public DialKeyStore(ConfigSource secretSource, String storeAlias) {
        this.secretSource = secretSource;
        this.storeAlias = storeAlias;
        try {
            this.loadKeystore();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    public Key read(String keyId) {
        try {
            return this.keyStore.getKey(keyId, this.secretSource.readKeySecret(this.storeAlias, keyId));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException(e);
        }
    }

    public void write(String keyId, Key key, X509Certificate[] certs) {
        try {
            this.keyStore.setKeyEntry(keyId, key, this.secretSource.readKeySecret(this.storeAlias, keyId), certs);
            FileOutputStream fos = new FileOutputStream(this.secretSource.readFilePath(this.storeAlias));
            this.keyStore.store(fos, this.secretSource.readStoreSecret(this.storeAlias));
            fos.close();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    private void loadKeystore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (this.keyStore != null) {
            return;
        }
        String filePath = this.secretSource.readFilePath(this.storeAlias);
        File file = new File(filePath);
        this.keyStore = KeyStore.getInstance("UBER");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.keyStore.load(null, null);
        } else {
            FileInputStream fis = new FileInputStream(file);
            this.keyStore.load(fis, this.secretSource.readStoreSecret(this.storeAlias));
            fis.close();
        }
    }
}

