/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.entity;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class EntityWrapper {
    protected final float yaw;
    protected final float pitch;
    private final Entity entity;
    private final EntityType type;
    public double x;
    public double y;
    public double z;

    EntityWrapper(@NonNull Entity entity) {
        this.entity = entity;
        this.type = entity.getType();
        Location location = entity.getLocation();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
    }

    public String toString() {
        return String.format("[%s, x=%s, y=%s, z=%s]", this.type.getName(), this.x, this.y, this.z);
    }

    public abstract Entity spawn(World var1, int var2, int var3);

    public abstract void saveEntity();

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public EntityType getType() {
        return this.type;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

