/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.inject;

import com.google.inject.AbstractModule;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.plotsquared.core.backup.BackupManager;
import com.plotsquared.core.backup.BackupProfile;
import com.plotsquared.core.backup.NullBackupManager;
import com.plotsquared.core.backup.PlayerBackupProfile;
import com.plotsquared.core.backup.SimpleBackupManager;
import com.plotsquared.core.inject.factory.PlayerBackupProfileFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupModule
extends AbstractModule {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + BackupModule.class.getSimpleName()));

    protected void configure() {
        try {
            this.install(new FactoryModuleBuilder().implement(BackupProfile.class, PlayerBackupProfile.class).build(PlayerBackupProfileFactory.class));
            this.bind(BackupManager.class).to(SimpleBackupManager.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize backup manager", (Throwable)e);
            LOGGER.error("Backup features will be disabled");
            this.bind(BackupManager.class).to(NullBackupManager.class);
        }
    }
}

